/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

public class LetterComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);
    protected Object selectedAccount;
    protected List<Letter> datasCache;
    protected FinancialTransactionServiceMonitorable service = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);

    public LetterComboBoxModel() {
        this.service.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedAccount;
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedAccount = anItem;
        this.fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    public List<Letter> getDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.service.getAllLetters();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get list letters", (Throwable)eee);
            }
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (methodeName.contains("Letter") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

