/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.combobox;

import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialperiod.FinancialPeriodTableModel;

public class FiscalPeriodComboBoxModel
extends AbstractListModel
implements ComboBoxModel,
ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialPeriodTableModel.class);
    protected Object selectedFiscalPeriod;
    protected FiscalPeriodServiceMonitorable fiscalPeriodService = LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
    protected List<FiscalPeriod> datasCache;

    public FiscalPeriodComboBoxModel() {
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.datasCache = this.getDataList();
    }

    public FiscalPeriodComboBoxModel(boolean all) {
        this.fiscalPeriodService.addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        this.datasCache = this.getAllDataList();
    }

    @Override
    public int getSize() {
        return this.datasCache.size();
    }

    @Override
    public Object getElementAt(int index) {
        return this.datasCache.get(index);
    }

    @Override
    public void setSelectedItem(Object anItem) {
        this.selectedFiscalPeriod = anItem;
    }

    @Override
    public Object getSelectedItem() {
        return this.selectedFiscalPeriod;
    }

    public List<FiscalPeriod> getDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.fiscalPeriodService.getAllUnblockedFiscalPeriods();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get list accounts", (Throwable)eee);
            }
        }
        return result;
    }

    public List<FiscalPeriod> getAllDataList() {
        List result;
        block2: {
            result = null;
            try {
                result = this.fiscalPeriodService.getAllFiscalPeriods();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't get list accounts", (Throwable)eee);
            }
        }
        return result;
    }

    public void refresh() {
        this.datasCache = this.getDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void refreshAll() {
        this.datasCache = this.getAllDataList();
        this.fireContentsChanged(this, 0, this.datasCache.size());
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FiscalPeriod") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

