/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.ServiceListener;

public class ServiceMonitorableHandler
implements InvocationHandler {
    private static final Log log = LogFactory.getLog(ServiceMonitorableHandler.class);
    private Object service;
    private List<ServiceListener> listeners;

    public ServiceMonitorableHandler(Object service) {
        this.service = service;
        this.listeners = new ArrayList<ServiceListener>();
    }

    public void addServiceListener(ServiceListener serviceListener) {
        this.listeners.add(serviceListener);
    }

    public void removeServiceListener(ServiceListener serviceListener) {
        this.listeners.remove(serviceListener);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (method.getName().equals("addListener")) {
            this.addServiceListener((ServiceListener)args[0]);
        } else if (method.getName().equals("removeListener")) {
            this.removeServiceListener((ServiceListener)args[0]);
        } else {
            try {
                result = method.invoke(this.service, args);
            }
            catch (InvocationTargetException eee) {
                throw eee.getCause();
            }
            if (!method.getName().startsWith("get")) {
                for (ServiceListener serviceListener : this.listeners) {
                    serviceListener.notifyMethod(this.service.toString(), method.getName());
                    log.debug((Object)("proxy : " + this.service.toString() + " " + method.getName()));
                }
            }
        }
        return result;
    }
}

