/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialTransactionSearchViewHandler.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransactionsearch/FinancialTransactionSearchViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransactionsearch;

import static org.nuiton.i18n.I18n._;

import java.util.Date;

import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.FinancialStatementWayEnum;
import org.chorem.lima.beans.FinancialTransactionSearch;
import org.chorem.lima.beans.FinancialTransactionSearchImpl;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ejbinterface.FinancialTransactionService;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.util.DialogHelper;

/**
 * Handler associated with financial transaction view.
 * 
 * @author chatellier
 * @version $Revision: 3278 $
 * 
 * Last update : $Date: 2011-08-16 16:09:44 +0200 (Tue, 16 Aug 2011) $
 * By : $Author: tchemit $
 */
public class FinancialTransactionSearchViewHandler {

    /** log. */
    private static final Log log =
        LogFactory.getLog(FinancialTransactionSearchViewHandler.class);

    protected FinancialTransactionSearchView view;
    
    protected FinancialTransactionSearchTable table;
    
    protected FinancialTransactionSearchTableModel tableModel;
    
    protected FiscalPeriodComboBoxModel comboBoxModel;
    
    /** Transaction service. */
    protected final FinancialTransactionService financialTransactionService;
    
    /** data cache */
    protected FinancialTransactionSearch financialTransactionSearch;
    
    protected Object clipBoard;

    protected FinancialTransactionSearchViewHandler(FinancialTransactionSearchView view) {
        this.view = view;
        
        /* Services */
        financialTransactionService =
            LimaServiceFactory.getInstance().getService(
                    FinancialTransactionServiceMonitorable.class);
        
        financialTransactionSearch = new FinancialTransactionSearchImpl();
        
    }
    
    public void setBeginDate(Date beginDate){
        financialTransactionSearch.setBeginDate(beginDate);
    }
    
    public void setEndDate(Date endDate){
        financialTransactionSearch.setEndDate(endDate);
    }
    
    public void setVoucher(String voucher){

        String result = null;
        if (!voucher.equals("")){
            result = voucher;
        }
        financialTransactionSearch.setVoucher(result);
    }
    
    public void setDescription(String description){
        String result = null;
        if (!description.equals("")){
            result = description;
        }
        financialTransactionSearch.setDescription(result);
    }
    
    public void setLetter(Letter letter){
        financialTransactionSearch.setLetter(letter);
    }
    
    public String getAccountsList(){
        return financialTransactionSearch.getAccountList();
    }
    
    public void setAccountsList(String accountsList){
        String result = null;
        if (!accountsList.equals("")){
            result = accountsList;
        }
        financialTransactionSearch.setAccountList(result);
    }

    public Account getAccount(){
        return financialTransactionSearch.getAccount();
    }
    
    public void setAccount(Account account){
        financialTransactionSearch.setAccount(account);
    }
    
    public void setEntryBook(EntryBook entryBook){
        financialTransactionSearch.setEntryBook(entryBook);
    }

    
    public String getAmount(){
        return financialTransactionSearch.getAmount();
    }
    
    public void setAmount(String amount){
        String result = null;
        if (!amount.equals("")){
            result = amount;
        }
        financialTransactionSearch.setAmount(result);
    }
    
    public String getAmount2(){
        return financialTransactionSearch.getAmount2();
    }
    
    public void setAmount2(String amount2){
        String result = null;
        if (!amount2.equals("")){
            result = amount2;
        }
        financialTransactionSearch.setAmount2(result);
    }
    
    public void setAmountWayEnum(FinancialStatementWayEnum amountWayEnum){
        financialTransactionSearch.setAmountWayEnum(amountWayEnum);
    }

    public void setOperator(String operator){
        String result = null;
        if (!operator.equals("")){
            result = operator;
        }
        financialTransactionSearch.setOperator(result);
    }
    
    /**
     * Delete selected row in table (could be transaction or entry).
     * 
     * Called by model.
     * @throws LimaException 
     */
    public void deleteSelectedRow(){

        table = view.getFinancialTransactionSearchTable();
        tableModel = view.getFinancialTransactionSearchTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {

            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            String message = null;
            if (selectedValue instanceof FinancialTransaction) {
                message = _("lima.charts.financialtransaction.question.removetransaction");
            }
            else {
                message = _("lima.charts.financialtransaction.question.removeentry");
            }

            int response = JOptionPane.showConfirmDialog(view, message,
                    _("lima.common.confirmation"), JOptionPane.YES_NO_OPTION);

            if (response == JOptionPane.YES_OPTION) {
                
                try {
                    tableModel.removeObject(selectedValue, indexSelectedRow);
                    //select the upper line
                    ListSelectionModel selectionModel = 
                        table.getSelectionModel();
                    selectionModel.setSelectionInterval(
                            indexSelectedRow-1, indexSelectedRow-1);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't remove transaction or entry", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call delete selected row without selection");
            }
        }
    }
    
    
    //implement new transaction button
    //add a new entry to the selected transaction
    public void addEmptyEntry(){
        
        table = view.getFinancialTransactionSearchTable();
        tableModel = view.getFinancialTransactionSearchTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            try {
                //copy + paste the description
                String description = (String) tableModel.getValueAt(indexSelectedRow, 4);
                int index = tableModel.addEmptyEntry(selectedValue, description, indexSelectedRow);
                //select the new line
                ListSelectionModel selectionModel = 
                    table.getSelectionModel();
                  selectionModel.setSelectionInterval(
                          indexSelectedRow+1, indexSelectedRow+1);
                  //focus on second column
                  table.changeSelection(index, 1, false, false);
                  table.requestFocusInWindow();
            } catch (LimaException eee){
                if (log.isErrorEnabled()) {
                    log.error("Can't add emptyentry", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call addentry selected transaction without selection");
            }
        }
    }
    
    
    //copy entry 
    public void copyRow(){
        table = view.getFinancialTransactionSearchTable();
        int indexSelectedRow = table.getSelectedRow();
        
        if (indexSelectedRow != -1) {
            clipBoard = tableModel.getElementAt(indexSelectedRow);
        }
    }
    
    //paste entry
    public void pasteRow(){
        table = view.getFinancialTransactionSearchTable();
        int indexSelectedRow = table.getSelectedRow();
        
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            if (clipBoard instanceof Entry) {
                try {
                    int index = tableModel.addEntry(selectedValue, (Entry) clipBoard, indexSelectedRow);
                    //select the new line
                    ListSelectionModel selectionModel = 
                        table.getSelectionModel();
                      selectionModel.setSelectionInterval(
                              indexSelectedRow+1, indexSelectedRow+1);
                      //focus on second column
                      table.changeSelection(index, 1, false, false);
                      table.requestFocusInWindow();
                } catch (LimaException eee){
                    if (log.isErrorEnabled()) {
                        log.error("Can't past entry", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }

        }
        
    }
    
    
    //add a new transaction
    public void addFinancialTransaction() {
        table = view.getFinancialTransactionSearchTable();
        tableModel = view.getFinancialTransactionSearchTableModel();

        try {
            int index = tableModel.addFinancialTransaction();
            //select the new line
            int numberRow = table.getRowCount();
            ListSelectionModel selectionModel = 
                table.getSelectionModel();
            selectionModel.setSelectionInterval(numberRow-1, numberRow-1);
            //focus on first column
            table.changeSelection(index, 0, false, false);
            table.requestFocusInWindow();
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't add financialtransaction", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }


    public void refresh(){
        tableModel = view.getFinancialTransactionSearchTableModel();
        if (tableModel != null){
            tableModel.refresh(financialTransactionSearch);
        }
    }

}
