/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodComboBox.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialtransaction/FinancialPeriodComboBox.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialtransaction;

import javax.swing.JComboBox;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.entity.FinancialPeriod;

public class FinancialPeriodComboBox extends JComboBox {

    private static final long serialVersionUID = 1L;

    private static final Log log =
        LogFactory.getLog(FinancialPeriodComboBox.class);
    
    protected FinancialTransactionViewHandler handler;
    
    public FinancialPeriodComboBox(FinancialTransactionViewHandler handler) {
        this.handler = handler;
    }

    public void back(){
        int row = this.getSelectedIndex();
        log.debug(row);
        if (row > 0){
            this.setSelectedItem(this.getItemAt(row-1));
            repaint();
            handler.tableModel.setFinancialPeriod( (FinancialPeriod) this.getSelectedItem());
        }
    }
    
    public void next(){
        int size = this.getModel().getSize();
        int row = this.getSelectedIndex();
        log.debug(row);
        
        if (row < size-1){
            this.setSelectedItem(this.getItemAt(row+1));
            repaint();
            //FIXME
            handler.tableModel.setFinancialPeriod( (FinancialPeriod) this.getSelectedItem());
        }
    }
}
