/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialPeriodTable.java 3278 2011-08-16 14:09:44Z tchemit $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.5.1/lima-swing/src/main/java/org/chorem/lima/ui/financialperiod/FinancialPeriodTable.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialperiod;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialPeriodServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ejbinterface.FinancialPeriodService;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.entity.ClosedPeriodicEntryBookImpl;
import org.chorem.lima.service.LimaServiceFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;

public class FinancialPeriodTable extends JXTable
        implements KeyListener, MouseListener {
    
    private static final long serialVersionUID = -1960326844433064178L;

    private static final Log log =
        LogFactory.getLog(FinancialPeriodTableModel.class);
    
    protected FinancialPeriodViewHandler handler;
    
    protected FinancialPeriodTableModel model;
    
    protected FinancialPeriodService financialPeriodService;
    
    private Highlighter colorTransaction;
    
    /*
     * Constructor, call highlighter
     */
    public FinancialPeriodTable(FinancialPeriodViewHandler handler) {

        this.handler = handler;
        
        addKeyListener(this);
        addMouseListener(this);
        
        model = this.handler.getView().modelFinancialPeriodTable;
        financialPeriodService =
            LimaServiceFactory.getInstance().getService(
                    FinancialPeriodServiceMonitorable.class);

        //highlight financial financial transactions
        addMonthColor();
        addBlockColor();
    }

    /*
     * Color the background row in grey if the month number is even (pair in french)
     */
    protected void addMonthColor() {
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                    ComponentAdapter adapter) {
                ClosedPeriodicEntryBook closedPeriodicEntryBook
                    = (ClosedPeriodicEntryBook) model.getElementAt(adapter.row);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM");
                int month = Integer.parseInt(simpleDateFormat.format(
                        closedPeriodicEntryBook.getFinancialPeriod().getBeginDate()));
                // true if month is even 
                return ((month % 2)==0);
                
            }
        };
         colorTransaction =
             new ColorHighlighter(predicate, new Color(222,222,222), null);
         addHighlighter(colorTransaction);
     }
    
    /*
     * Color the font in red if period are closed
     */
    protected void addBlockColor() {
        HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                    ComponentAdapter adapter) {
                ClosedPeriodicEntryBook closedPeriodicEntryBook =
                    new ClosedPeriodicEntryBookImpl();
                ClosedPeriodicEntryBook selectedClosedPeriodicEntryBook =
                    (ClosedPeriodicEntryBook) model.getElementAt(adapter.row);
                // true if locked 
                try {
                    closedPeriodicEntryBook =
                        financialPeriodService.getClosedPeriodicEntryBook(
                                selectedClosedPeriodicEntryBook.getEntryBook(),
                                selectedClosedPeriodicEntryBook.getFinancialPeriod());
                } catch (LimaException eee) {
                    log.debug("Can't get closePeriodicEntryBook",eee);
                }
                return (closedPeriodicEntryBook.getLocked());
            }
        };
         colorTransaction =
             new ColorHighlighter(predicate, null, new Color(222,0,0));
         addHighlighter(colorTransaction);
     }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.rowAtPoint(e.getPoint()) == -1) {
            this.clearSelection();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    /**
     * for each action combination key are think
     * for extend keyboard and laptop keyboard
     */
    @Override
    public void keyPressed(KeyEvent e) {
        // clear row selection with the key: escape
        if (e.getKeyCode() == KeyEvent.VK_ESCAPE) {
        	if (!this.isEditing()) {
                this.clearSelection();
        	}
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }
    
}
