/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionunbalanced;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTable;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedTableModel;
import org.chorem.lima.ui.financialtransactionunbalanced.FinancialTransactionUnbalancedView;
import org.chorem.lima.util.DialogHelper;
import org.nuiton.i18n.I18n;

public class FinancialTransactionUnbalancedViewHandler {
    private static final Log log = LogFactory.getLog(FinancialTransactionUnbalancedViewHandler.class);
    protected FinancialTransactionUnbalancedView view;
    protected FinancialTransactionUnbalancedTable table;
    protected FinancialTransactionUnbalancedTableModel tableModel;
    protected FiscalPeriodComboBoxModel comboBoxModel;

    protected FinancialTransactionUnbalancedViewHandler(FinancialTransactionUnbalancedView view) {
        this.view = view;
    }

    public void addEmptyEntry() {
        this.table = this.view.getFinancialTransactionUnbalancedTable();
        this.tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            try {
                this.tableModel.addEmptyEntry(selectedValue, indexSelectedRow);
                ListSelectionModel selectionModel = this.table.getSelectionModel();
                selectionModel.setSelectionInterval(indexSelectedRow + 1, indexSelectedRow + 1);
                this.table.changeSelection(indexSelectedRow + 1, 1, false, false);
                this.table.requestFocusInWindow();
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add emptyentry", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call addentry selected transaction without selection");
        }
    }

    public void deleteSelectedRow() {
        this.table = this.view.getFinancialTransactionUnbalancedTable();
        this.tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        int indexSelectedRow = this.table.getSelectedRow();
        if (indexSelectedRow != -1) {
            Object selectedValue = this.tableModel.getElementAt(indexSelectedRow);
            String message = null;
            message = selectedValue instanceof FinancialTransaction ? I18n._((String)"lima.charts.financialtransaction.question.removetransaction") : I18n._((String)"lima.charts.financialtransaction.question.removeentry");
            int response = JOptionPane.showConfirmDialog((Component)((Object)this.view), message, I18n._((String)"lima.common.confirmation"), 0);
            if (response == 0) {
                try {
                    this.tableModel.removeObject(selectedValue, indexSelectedRow);
                    ListSelectionModel selectionModel = this.table.getSelectionModel();
                    selectionModel.setSelectionInterval(indexSelectedRow - 1, indexSelectedRow - 1);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't remove transaction or entry", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        } else if (log.isWarnEnabled()) {
            log.warn((Object)"Call delete selected row without selection");
        }
    }

    public void refresh() {
        this.tableModel = this.view.getFinancialTransactionUnbalancedTableModel();
        this.tableModel.refresh();
        this.comboBoxModel = this.view.getModelFiscalPeriod();
        this.comboBoxModel.refresh();
    }
}

