/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.entrybook;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.enums.EntryBooksChartEnum;
import org.chorem.lima.ui.entrybook.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class EntryBookImportForm extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ADD_STATE = "addState";
    public static final String PROPERTY_RADIO_BUTTONS = "radioButtons";

    /*-----------------------------------------------------------------------*/
    /*--------------- Constants for all none public bindings  ---------------*/
    /*-----------------------------------------------------------------------*/

    private static final String BINDING_$JRADIO_BUTTON0_BUTTON_GROUP = "$JRadioButton0.buttonGroup";
    private static final String BINDING_$JRADIO_BUTTON1_BUTTON_GROUP = "$JRadioButton1.buttonGroup";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVTz08TQRSerhQoxV+gFRRMReLBxG1N9CJEELAKqZpQD8RenO1O2oXZnXF2FpaL8U/wT9C7FxNvnowHzx68GP8FYzx4Nb6ZbXepLrWhPWwn8973ve97896b7yjrC3RpG4ehKQJPOi4xN+5sbT2ytklDrhG/IRwumUDRL2Mgo47ydnzvS3S5XlXwUhteWmUuZx7xDqAXqmjMl/uU+C1CpESz3YiG75dqcXgh5IHosMai0lhf/fxhvLRfvDYQCjmoy4GV4v9QiZOhKjIcW6IJqLSLSxR7TZAhHK8Jeo+ru1WKff8hdskz9ByNVNEwxwLIJJrr37Lm0PiQS5Sb31hzMGXNskRlJppmo8UEcU3quNgMHBM4xL7F2I55V51W4LQO3EJWmHA510TDEo0LbDtsJZCSefAEc12m/T2woF8xSrgnWMAT7Ci27ZrEkkh0Wpk0lXETKlGCvSRtZP4xtigBnVMp7DqmMnMx4MT8xmaiKsLt4rAj50BMASYOwV1Xt+e6M9pSdOhMdwj6Gdeb7KqXlDofZxtsR50utm8FutBlDebQTOYwGZRMHWVFANfgqf7v6G5CKBraqb+GVhHq6O/C5Jf3395VOpOah9pnU1MPLBpMEBeMEyEdVfpkNKaBdGjpAeYLdZh3QmFL9RbOpAirtcMgDupFj63g5n3st4AiO/L1w8fC08/HkFFBY5Rhu4JV/jrKyZaALjBqh3xpWSsa3xuF7ymlTaKsy2xMYXUWHY86HiliCYtjBZLcDqEPMyl9iMVYuU+/Jmtvlzu9yIC26UPTk35kn6DhqJre2/ZKpu5pnvsksFmyemnLmFH/Y53FuKK/V9PM5q1kjWBcF20scdFyPBvmDOwqnKl9qFNZ0xb6oB2NXo9oJ9eOzjMkSSgH5MjuYhro7t08Kom6vtGDYbovhls9jPTHsDQww9rALnppmB2YoQgMfwBYtmwnuQcAAA==";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.entrybook.EntryBookImportForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.lang.Boolean addState;
    protected javax.swing.JButton ok;
    protected jaxx.runtime.swing.JAXXButtonGroup radioButtons;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private EntryBookImportForm $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JRadioButton $JRadioButton0;
    private javax.swing.JRadioButton $JRadioButton1;
    private jaxx.runtime.swing.Table $Table1;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            getRadioButtons().setSelectedValue(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public EntryBookImportForm() {
        $initialize();
    }

    public EntryBookImportForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        dispose();
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public java.lang.Boolean getAddState() {
        return addState;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getRadioButtons() {
        return radioButtons;
    }

    public java.lang.Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void setAddState(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.addState;
        this.addState = newValue;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, newValue);
    }

    public void setRadioButtons(jaxx.runtime.swing.JAXXButtonGroup newValue) {
        jaxx.runtime.swing.JAXXButtonGroup oldValue = this.radioButtons;
        this.radioButtons = newValue;
        firePropertyChange(PROPERTY_RADIO_BUTTONS, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JRadioButton get$JRadioButton0() {
        return $JRadioButton0;
    }

    protected javax.swing.JRadioButton get$JRadioButton1() {
        return $JRadioButton1;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    protected void createRadioButtons() {
        $objectMap.put("radioButtons", radioButtons = new JAXXButtonGroup());
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JRadioButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JRadioButton1, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($Table1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        // inline complete setup of $Table1
        $Table1.add($JButton0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(ok, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 2 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // apply 2 property setters
        { $JRadioButton0.putClientProperty("$value", EntryBooksChartEnum.DEFAULT);  Object $buttonGroup = $JRadioButton0.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        
        { $JRadioButton1.putClientProperty("$value", EntryBooksChartEnum.IMPORT);  Object $buttonGroup = $JRadioButton1.getClientProperty("$buttonGroup"); if ($buttonGroup instanceof jaxx.runtime.swing.JAXXButtonGroup) { ((jaxx.runtime.swing.JAXXButtonGroup) $buttonGroup).updateSelectedValue(); } }
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createRadioButtons();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JRadioButton0
        $objectMap.put("$JRadioButton0", $JRadioButton0 = new javax.swing.JRadioButton());
        
        $JRadioButton0.setName("$JRadioButton0");
        $JRadioButton0.setSelected(true);
        $JRadioButton0.setText(_("lima.charts.entrybook.default"));
        // inline creation of $JRadioButton1
        $objectMap.put("$JRadioButton1", $JRadioButton1 = new javax.swing.JRadioButton());
        
        $JRadioButton1.setName("$JRadioButton1");
        $JRadioButton1.setSelected(true);
        $JRadioButton1.setText(_("lima.charts.entrybook.import"));
        // inline creation of $Table1
        $objectMap.put("$Table1", $Table1 = new jaxx.runtime.swing.Table());
        
        $Table1.setName("$Table1");
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(ok);// registers 2 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 2 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON0_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton0.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton0); }
            }
        });
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_$JRADIO_BUTTON1_BUTTON_GROUP, true ,"radioButtons") {
        
            @Override
            public void processDataBinding() {
                { javax.swing.ButtonGroup $buttonGroup = getRadioButtons(); $JRadioButton1.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add($JRadioButton1); }
            }
        });
    }

}