/*
 * #%L
 * Lima :: Swing
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2008 - 2011 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package org.chorem.lima.ui.account;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.*;
import jaxx.runtime.JAXXBinding;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.JAXXObjectDescriptor;
import jaxx.runtime.binding.DefaultJAXXBinding;
import jaxx.runtime.binding.SimpleJAXXObjectBinding;
import jaxx.runtime.swing.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.ui.account.*;
import static jaxx.runtime.SwingUtil.createImageIcon;
import static org.nuiton.i18n.I18n._;

public class AccountForm extends javax.swing.JDialog implements JAXXObject {

    /*-----------------------------------------------------------------------*/
    /*---------------- Constants for all javaBean properties ----------------*/
    /*-----------------------------------------------------------------------*/

    public static final String PROPERTY_ACCOUNT = "account";
    public static final String PROPERTY_ADD_STATE = "addState";

    /*-----------------------------------------------------------------------*/
    /*------------------ Constants for all public bindings ------------------*/
    /*-----------------------------------------------------------------------*/

    public static final String BINDING_DESCRIPTION_TEXT_FIELD_TEXT = "descriptionTextField.text";
    public static final String BINDING_NUMBER_TEXT_FIELD_EDITABLE = "numberTextField.editable";
    public static final String BINDING_NUMBER_TEXT_FIELD_TEXT = "numberTextField.text";

    /*-----------------------------------------------------------------------*/
    /*------------------------- Other static fields -------------------------*/
    /*-----------------------------------------------------------------------*/

    private static final String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUTW/TQBCdhKZN0kKhhdBCCy2EipMDSCCkVqVfiqAKIJEeKnJhE6+SLbZ3Wa+pe0H8BH4C3LkgceOEOHDmwAXxFxDiwBUxaztx3LpqpeSwdmbmvXkzntn3vyDnSpjfIb5vSM9RzKbG5ur29uPmDm2pDeq2JBOKSwh/mSxkGzBq9uyugquNmoZXInhlnduCO9TpQy/WoOiqPYu6HUqVgtkkouW6lXrPvegLT3ZZe6LSWN/++Z19Y75+lwXwBaobw1LmjkLFlQzVIMtMBROY6SWpWMRpowzJnDbqPalt6xZx3UfEpi/gFYzUYFgQiWQKrhy/5IAjwPtCQaG8ucGIxds3FCxw2TZaHS6pbVjMJobHDNJqcSQ1VsNnlUtbiAA+rGAk8iq4tB+KuZna68JiSJ6YZl0RRRWc0RUZukpjjXOLEqePubxFmhZFUVOJ/rm72A0j8OnIQsxb3qyRJrUQMaF5/Sg0tOqgiV7suOPZTSq3qK+qjFrY8VIC0nMkYcXyBm95NlaGSab7EQoBRtcpDmi6qf+fT5Kd7Y4s404i34XDkgYsszE7frk1TynuoJrJhP7QnOTJ8uf6bSGySriY6CtOvBFPfDySmQbkpIdm/BCNg0vyBF3hekztWw9NGHj/lSa/f/r5sdrdiTzmPpca2rfSOKtCckGlYjr1eLgQnmJW5SERiw0ouNTC+yDY95kUYfXIjeIwXzhpGm7cJ24HKXIjPz5/KT37dgKyVShanJhVouMfQEF1JHaBW6Yv7q0EisZ283ie1toU5GxuEgunbIk5FnPoHFG4ok1P0WUf+zCT0oeemGbh69/J+oeVbi8yqG360PC4H7mnMBxmC26IaPlTb4RR4VLP5PGSp619Rj+LIpolIzhvpRU7pCdbe2/7nn7cCUTrt7sBR+kYHHlqMqUXVsGpJZMoMtdkjomDupzOOX0kpzYv6WNtYIZD6ro8sIb5gTVcG5jhOjL8B2dRuVNRBwAA";
    public static final String PROPERTY$DOCUMENT0 = "$Document0";
    public static final String PROPERTY$DOCUMENT1 = "$Document1";
    private static final Log log = LogFactory.getLog(org.chorem.lima.ui.account.AccountForm.class);
    private static final long serialVersionUID = 1L;

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Internal states ---------------------------*/
    /*-----------------------------------------------------------------------*/

    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected Map<String, Object> $bindingSources = new HashMap<String, Object>();
    protected final Map<String, JAXXBinding> $bindings = new java.util.TreeMap<String, JAXXBinding>();
    protected Map<String, Object> $objectMap = new HashMap<String, Object>();
    protected Map<?,?> $previousValues = new java.util.HashMap<Object, Object>();
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    protected final JAXXContext delegateContext = new jaxx.runtime.context.DefaultJAXXContext();

    /*-----------------------------------------------------------------------*/
    /*------------------------ Protected components  ------------------------*/
    /*-----------------------------------------------------------------------*/

    protected org.chorem.lima.entity.Account account;
    protected java.lang.Boolean addState;
    protected javax.swing.JTextField descriptionTextField;
    protected javax.swing.JTextField numberTextField;
    protected javax.swing.JButton ok;

    /*-----------------------------------------------------------------------*/
    /*------------------------- Private components  -------------------------*/
    /*-----------------------------------------------------------------------*/

    private AccountForm $JDialog0 = this;
    private jaxx.runtime.swing.Table $Table0;
    private javax.swing.JLabel $JLabel0;
    private javax.swing.text.Document $Document0;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.text.Document $Document1;
    private javax.swing.JButton $JButton0;

    /*-----------------------------------------------------------------------*/
    /*---------------------- Raw body code from script ----------------------*/
    /*-----------------------------------------------------------------------*/
    
        protected void performCancel() {
            setAccount(null);
            dispose();
        }

    /*-----------------------------------------------------------------------*/
    /*--------------------------- Statics methods ---------------------------*/
    /*-----------------------------------------------------------------------*/

    public static JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return JAXXUtil.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Constructors  ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public AccountForm() {
        $initialize();
    }

    public AccountForm(JAXXContext parentContext) {
        JAXXUtil.initContext(this, parentContext);
        $initialize();
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------- JAXXObject implementation ----------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public void applyDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).applyDataBinding();
        }
        processDataBinding($binding);
    }

    @Override
    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    @Override
    public Map<String, Object> get$objectMap() {
        return $objectMap;
    }

    @Override
    public JAXXBinding[] getDataBindings() {
        return $bindings.values().toArray(new JAXXBinding[$bindings.size()]);
    }

    @Override
    public Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    @Override
    public void processDataBinding(String $binding, boolean $force) {
        if (!$force && $activeBindings.contains($binding)) { 
            return;
        }
        $activeBindings.add($binding);
        try {
            if (allComponentsCreated && $bindings.containsKey($binding)) {
                $bindings.get($binding).processDataBinding();
            }
        } finally {
            $activeBindings.remove($binding);
        }
    }

    @Override
    public void processDataBinding(String $binding) {
        processDataBinding($binding, false);
    }

    @Override
    public void registerDataBinding(JAXXBinding binding) {
        $bindings.put(binding.getId(), binding);
    }

    @Override
    public void removeDataBinding(String $binding) {
        if (allComponentsCreated && $bindings.containsKey($binding)) {
            $bindings.get($binding).removeDataBinding();
        }
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- JAXXContext implementation  ---------------------*/
    /*-----------------------------------------------------------------------*/

    @Override
    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    @Override
    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    @Override
    public JAXXContext getDelegateContext() {
        return delegateContext;
    }

    @Override
    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return SwingUtil.getParentContainer(this, clazz);
    }

    @Override
    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return SwingUtil.getParentContainer(source, clazz);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    @Override
    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    @Override
    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    @Override
    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*-----------------------------------------------------------------------*/
    /*---------------------------- Event methods ----------------------------*/
    /*-----------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton0(java.awt.event.ActionEvent event) {
        performCancel();
    }

    public void doActionPerformed__on__ok(java.awt.event.ActionEvent event) {
        dispose();
    }

    public void doInsertUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getAccount().setLabel(getDescriptionTextField().getText());
    }

    public void doRemoveUpdate__on__$Document1(javax.swing.event.DocumentEvent event) {
        getAccount().setLabel(getDescriptionTextField().getText());
    }

    public void doInsertUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getAccount().setAccountNumber(getNumberTextField().getText());
    }

    public void doRemoveUpdate__on__$Document0(javax.swing.event.DocumentEvent event) {
        getAccount().setAccountNumber(getNumberTextField().getText());
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public acessor methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public org.chorem.lima.entity.Account getAccount() {
        return account;
    }

    public java.lang.Boolean getAddState() {
        return addState;
    }

    public javax.swing.JTextField getDescriptionTextField() {
        return descriptionTextField;
    }

    public javax.swing.JTextField getNumberTextField() {
        return numberTextField;
    }

    public javax.swing.JButton getOk() {
        return ok;
    }

    public java.lang.Boolean isAddState() {
        return addState !=null && addState;
    }

    /*-----------------------------------------------------------------------*/
    /*----------------------- Public mutator methods  -----------------------*/
    /*-----------------------------------------------------------------------*/

    public void set$Document0(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document0;
        this.$Document0 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT0, oldValue, newValue);
    }

    public void set$Document1(javax.swing.text.Document newValue) {
        javax.swing.text.Document oldValue = this.$Document1;
        this.$Document1 = newValue;
        firePropertyChange(PROPERTY$DOCUMENT1, oldValue, newValue);
    }

    public void setAccount(org.chorem.lima.entity.Account newValue) {
        org.chorem.lima.entity.Account oldValue = this.account;
        this.account = newValue;
        firePropertyChange(PROPERTY_ACCOUNT, oldValue, newValue);
    }

    public void setAddState(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.addState;
        this.addState = newValue;
        firePropertyChange(PROPERTY_ADD_STATE, oldValue, newValue);
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Protected acessors methods  ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected jaxx.runtime.swing.Table get$Table0() {
        return $Table0;
    }

    protected javax.swing.JLabel get$JLabel0() {
        return $JLabel0;
    }

    protected javax.swing.text.Document get$Document0() {
        return $Document0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.text.Document get$Document1() {
        return $Document1;
    }

    protected javax.swing.JButton get$JButton0() {
        return $JButton0;
    }

    /*-----------------------------------------------------------------------*/
    /*--------------------- Components creation methods ---------------------*/
    /*-----------------------------------------------------------------------*/

    protected void createAccount() {
        $objectMap.put("account", account = null);
    }

    protected void createAddState() {
        $objectMap.put("addState", addState = true);
    }

    protected void createDescriptionTextField() {
        $objectMap.put("descriptionTextField", descriptionTextField = new javax.swing.JTextField());
        
        descriptionTextField.setName("descriptionTextField");
        descriptionTextField.setColumns(15);
    }

    protected void createNumberTextField() {
        $objectMap.put("numberTextField", numberTextField = new javax.swing.JTextField());
        
        numberTextField.setName("numberTextField");
        numberTextField.setColumns(15);
    }

    protected void createOk() {
        $objectMap.put("ok", ok = new javax.swing.JButton());
        
        ok.setName("ok");
        ok.setText(_("lima.common.ok"));
        ok.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__ok"));
    }

    /*-----------------------------------------------------------------------*/
    /*------------------------ Internal jaxx methods ------------------------*/
    /*-----------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        // inline complete setup of $JDialog0
        add($Table0);
        // inline complete setup of $Table0
        $Table0.add($JLabel0, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(numberTextField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JLabel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(descriptionTextField, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($JButton0, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(ok, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        
        // apply 3 data bindings
        JAXXUtil.applyDataBinding(this, $bindings.keySet());
        
        // late initializer
        $JDialog0.pack();
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JDialog0", this);
        createAccount();
        createAddState();
        // inline creation of $Table0
        $objectMap.put("$Table0", $Table0 = new jaxx.runtime.swing.Table());
        
        $Table0.setName("$Table0");
        // inline creation of $JLabel0
        $objectMap.put("$JLabel0", $JLabel0 = new javax.swing.JLabel());
        
        $JLabel0.setName("$JLabel0");
        $JLabel0.setText(_("lima.charts.account.number"));
        createNumberTextField();
        // inline creation of $Document0
        $objectMap.put("$Document0", $Document0 = getNumberTextField().getDocument());
        
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document0"));
        $Document0.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document0"));
        // inline creation of $JLabel1
        $objectMap.put("$JLabel1", $JLabel1 = new javax.swing.JLabel());
        
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("lima.common.label"));
        createDescriptionTextField();
        // inline creation of $Document1
        $objectMap.put("$Document1", $Document1 = getDescriptionTextField().getDocument());
        
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "insertUpdate", this, "doInsertUpdate__on__$Document1"));
        $Document1.addDocumentListener(JAXXUtil.getEventListener(DocumentListener.class, "removeUpdate", this, "doRemoveUpdate__on__$Document1"));
        // inline creation of $JButton0
        $objectMap.put("$JButton0", $JButton0 = new javax.swing.JButton());
        
        $JButton0.setName("$JButton0");
        $JButton0.setText(_("lima.common.cancel"));
        $JButton0.addActionListener(JAXXUtil.getEventListener(ActionListener.class, "actionPerformed", this, "doActionPerformed__on__$JButton0"));
        createOk();
        // inline creation of $JDialog0
        setName("$JDialog0");
        setModal(true);
        
        getRootPane().setDefaultButton(ok);// registers 3 data bindings
        $registerDefaultBindings();
        $completeSetup();
    }

    private void $registerDefaultBindings() {
        // register 3 data bindings
        registerDataBinding(new SimpleJAXXObjectBinding(this, BINDING_NUMBER_TEXT_FIELD_EDITABLE, true ,"addState") {
        
            @Override
            public void processDataBinding() {
                numberTextField.setEditable(isAddState());
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_NUMBER_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("accountNumber", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    jaxx.runtime.SwingUtil.setText(numberTextField, getAccount().getAccountNumber());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("accountNumber", this);
                }
            }
        });
        registerDataBinding(new DefaultJAXXBinding(this, BINDING_DESCRIPTION_TEXT_FIELD_TEXT, true) {
        
            @Override
            public void applyDataBinding() {
                addPropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().addPropertyChangeListener("label", this);
                }
            }
        
            @Override
            public void processDataBinding() {
                if (getAccount() != null) {
                    jaxx.runtime.SwingUtil.setText(descriptionTextField, getAccount().getLabel());
                }
            }
        
            @Override
            public void removeDataBinding() {
                removePropertyChangeListener("account", this);
                if (getAccount() != null) {
                    getAccount().removePropertyChangeListener("label", this);
                }
            }
        });
    }

}