/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.entrybooksreports;

import java.text.SimpleDateFormat;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Entry;
import org.nuiton.i18n.I18n;

public class EntryBooksReportsTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(EntryBooksReportsTableModel.class);
    protected ReportsDatas cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null && this.cacheDataList.getListEntry() != null) {
            result = this.cacheDataList.getListEntry().size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 7;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.date");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.account");
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.voucher");
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.description");
                break;
            }
            case 4: {
                res = I18n._((String)"lima.table.letter");
                break;
            }
            case 5: {
                res = I18n._((String)"lima.table.debit");
                break;
            }
            case 6: {
                res = I18n._((String)"lima.table.credit");
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList.getListEntry() != null) {
            Entry currentRow = (Entry)this.cacheDataList.getListEntry().get(row);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd MMMMM yyyy");
            switch (column) {
                case 0: {
                    result = simpleDateFormat.format(currentRow.getFinancialTransaction().getTransactionDate());
                    break;
                }
                case 1: {
                    if (currentRow.getAccount() != null) {
                        result = currentRow.getAccount().getAccountNumber();
                        break;
                    }
                    result = null;
                    break;
                }
                case 2: {
                    result = currentRow.getVoucher();
                    break;
                }
                case 3: {
                    result = currentRow.getDescription();
                    break;
                }
                case 4: {
                    if (currentRow.getLetter() != null) {
                        result = currentRow.getLetter().getCode();
                        break;
                    }
                    result = null;
                    break;
                }
                case 5: {
                    result = currentRow.getDebit() ? currentRow.getAmount() : Integer.valueOf(0);
                    break;
                }
                case 6: {
                    result = currentRow.getDebit() ? Integer.valueOf(0) : currentRow.getAmount();
                }
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)"No EntryBook selected skip table model update");
        }
        return result;
    }

    public Entry getElementAt(int row) {
        return (Entry)this.cacheDataList.getListEntry().get(row);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void refresh(ReportsDatas datasList) {
        this.cacheDataList = datasList;
        this.fireTableDataChanged();
    }
}

