/*
 * #%L
 * Lima Swing
 * 
 * $Id: FinancialStatementReportViewHandler.java 3051 2010-11-29 14:57:16Z echatellier $
 * $HeadURL: http://svn.chorem.org/svn/lima/tags/lima-0.4.2/lima-swing/src/main/java/org/chorem/lima/ui/financialstatementreport/FinancialStatementReportViewHandler.java $
 * %%
 * Copyright (C) 2008 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

package org.chorem.lima.ui.financialstatementreport;

import org.chorem.lima.business.utils.FormatsEnum;

/**
 * Handler associated with accounts reports view.
 * 
 * @author chatellier
 * @version $Revision: 3051 $
 * 
 * Last update : $Date: 2010-11-29 15:57:16 +0100 (lun., 29 nov. 2010) $
 * By : $Author: echatellier $
 */
public class FinancialStatementReportViewHandler {

    protected FinancialStatementReportView view;
    
    protected FinancialStatementReportTableModel model;
        
    protected FinancialStatementReportViewHandler(FinancialStatementReportView view) {
        this.view = view;
    }
    
    public void refresh(){
        model = view.getModelTable();
        model.refresh();  
    }
    
    public FinancialStatementReportView getView() {
        return view;
    }
    
    public void createDocument() {
        
        model = view.getModelTable();
        FormatsEnum selectedEnum = (FormatsEnum) view.getDocumentEditor().getSelectedItem();
        model.createDocument(selectedEnum);

    }
}
