/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.ledger;

import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ReportServiceMonitorable;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.EntryComparator;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.ledger.LedgerTableModel;
import org.chorem.lima.ui.ledger.LedgerView;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class LedgerViewHandler
implements ServiceListener {
    protected LedgerView view;
    protected LedgerTableModel model;
    private static final Log log = LogFactory.getLog(LedgerTableModel.class);
    protected ReportServiceMonitorable reportService;
    protected DocumentServiceMonitorable documentService;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected String selectedAccounts;
    protected BalanceTrial balanceTrialCache;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected int port;
    protected List<Object> cachedatasList;

    protected LedgerViewHandler(LedgerView view) {
        this.view = view;
        this.reportService = LimaServiceFactory.getInstance().getService(ReportServiceMonitorable.class);
        this.reportService.addListener((ServiceListener)this);
        this.port = LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).getHttpPort();
        this.documentService = LimaServiceFactory.getInstance().getService(DocumentServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
    }

    public void setAccountFilter(String accounts) {
        this.selectedAccounts = accounts;
        this.refresh();
    }

    public List<Object> getDataList() {
        ArrayList<Object> results = new ArrayList<Object>();
        try {
            this.balanceTrialCache = this.reportService.generateLedger(this.selectedBeginDate, this.selectedEndDate, this.selectedAccounts, Boolean.valueOf(this.view.getMovmentedFilter().isSelected()));
            if (this.balanceTrialCache.getReportsDatas() != null) {
                for (ReportsDatas reportsDatas : this.balanceTrialCache.getReportsDatas()) {
                    results.add(reportsDatas);
                    List entries = reportsDatas.getListEntry();
                    if (entries == null) continue;
                    Collections.sort(entries, new EntryComparator());
                    results.addAll(entries);
                }
            }
        }
        catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.debug((Object)"Can't update model", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog("Can't get entries list", eee);
        }
        return results;
    }

    public void refresh() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            this.model = this.view.getModelTable();
            this.cachedatasList = this.getDataList();
            this.model.refresh(this.cachedatasList);
            if (this.balanceTrialCache != null) {
                this.view.amountCreditLabel.setText(String.valueOf(this.balanceTrialCache.getAmountCredit()));
                this.view.amountDebitLabel.setText(String.valueOf(this.balanceTrialCache.getAmountDebit()));
                BigDecimal amountSolde = this.balanceTrialCache.getAmountSolde();
                this.view.amountSoldeLabel.setText(String.valueOf(amountSolde));
                if (amountSolde.doubleValue() == 0.0) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.solde"));
                } else if (this.balanceTrialCache.getSoldeDebit()) {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldedebit"));
                } else {
                    this.view.soldeLabel.setText(I18n._((String)"lima.common.soldecredit"));
                }
            }
        }
    }

    public void createDocument() {
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            FormatsEnum selectedEnum = (FormatsEnum)this.view.getDocumentEditor().getSelectedItem();
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.selectedBeginDate) + "&endDate=" + dateFormat.format(this.selectedEndDate) + "&format=" + selectedEnum.getExtension() + "&model=" + DocumentsEnum.LEDGER.getFileName();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("importAccount") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

