/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialtransactionsearch;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.FinancialTransactionSearch;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.Account;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.EntryBook;
import org.chorem.lima.entity.EntryImpl;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.entity.Letter;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialTransactionSearchTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialTransactionSearchTableModel.class);
    protected final FinancialTransactionServiceMonitorable financialTransactionService = LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class);
    protected FiscalPeriod selectedFiscalPeriod;
    protected FinancialTransactionSearch financialTransactionSearch;
    protected List<Object> cacheDataList;

    public FinancialTransactionSearchTableModel() {
        this.financialTransactionService.addListener((ServiceListener)this);
    }

    protected List<Object> getDataList(FinancialTransactionSearch financialTransactionSearch) {
        List results = null;
        if (financialTransactionSearch != null && (financialTransactionSearch.getVoucher() != null || financialTransactionSearch.getDescription() != null || financialTransactionSearch.getLetter() != null || financialTransactionSearch.getAccountList() != null || financialTransactionSearch.getAccount() != null || financialTransactionSearch.getEntryBook() != null || financialTransactionSearch.getAmount() != null && financialTransactionSearch.getOperator() != null || financialTransactionSearch.getAmount() != null && financialTransactionSearch.getAmount2() != null)) {
            try {
                results = this.financialTransactionService.searchFinancialTransaction(financialTransactionSearch);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog("Can't get transaction list", eee);
            }
        }
        return results;
    }

    protected void refresh(FinancialTransactionSearch financialTransactionSearch) {
        this.financialTransactionSearch = financialTransactionSearch;
        this.cacheDataList = this.getDataList(financialTransactionSearch);
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        Class result = null;
        switch (column) {
            case 0: {
                result = Date.class;
                break;
            }
            case 1: {
                result = EntryBook.class;
                break;
            }
            case 2: {
                result = String.class;
                break;
            }
            case 3: {
                result = Account.class;
                break;
            }
            case 4: {
                result = String.class;
                break;
            }
            case 5: {
                result = BigDecimal.class;
                break;
            }
            case 6: {
                result = BigDecimal.class;
                break;
            }
            case 7: {
                result = BigDecimal.class;
                break;
            }
            case 8: {
                result = Letter.class;
            }
        }
        return result;
    }

    @Override
    public String getColumnName(int column) {
        String result = "n/a";
        switch (column) {
            case 0: {
                result = I18n._((String)"lima.table.date");
                break;
            }
            case 1: {
                result = I18n._((String)"lima.table.entrybook");
                break;
            }
            case 2: {
                result = I18n._((String)"lima.table.voucher");
                break;
            }
            case 3: {
                result = I18n._((String)"lima.table.account");
                break;
            }
            case 4: {
                result = I18n._((String)"lima.table.description");
                break;
            }
            case 5: {
                result = I18n._((String)"lima.table.debit");
                break;
            }
            case 6: {
                result = I18n._((String)"lima.table.credit");
                break;
            }
            case 7: {
                result = I18n._((String)"lima.table.balance");
                break;
            }
            case 8: {
                result = I18n._((String)"lima.table.letter");
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.get(row);
            if (result instanceof FinancialTransaction) {
                FinancialTransaction currentRow = (FinancialTransaction)result;
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                switch (column) {
                    case 0: {
                        result = currentRow.getTransactionDate();
                        break;
                    }
                    case 1: {
                        if (currentRow.getEntryBook() != null) {
                            result = currentRow.getEntryBook().getCode();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 2: {
                        result = null;
                        break;
                    }
                    case 3: {
                        result = null;
                        break;
                    }
                    case 4: {
                        result = null;
                        break;
                    }
                    case 5: {
                        result = amountDebit;
                        break;
                    }
                    case 6: {
                        result = amountCredit;
                        break;
                    }
                    case 7: {
                        result = amountDebit.subtract(amountCredit);
                        break;
                    }
                    case 8: {
                        result = null;
                    }
                }
            } else if (result instanceof Entry) {
                Entry currentEntry = (Entry)result;
                switch (column) {
                    case 0: {
                        result = null;
                        break;
                    }
                    case 1: {
                        result = null;
                        break;
                    }
                    case 2: {
                        result = currentEntry.getVoucher();
                        break;
                    }
                    case 3: {
                        if (currentEntry.getAccount() != null) {
                            result = currentEntry.getAccount().getAccountNumber();
                            break;
                        }
                        result = null;
                        break;
                    }
                    case 4: {
                        result = currentEntry.getDescription();
                        break;
                    }
                    case 5: {
                        result = currentEntry.getDebit() ? currentEntry.getAmount() : Integer.valueOf(0);
                        break;
                    }
                    case 6: {
                        result = currentEntry.getDebit() ? Integer.valueOf(0) : currentEntry.getAmount();
                        break;
                    }
                    case 7: {
                        result = null;
                        break;
                    }
                    case 8: {
                        result = currentEntry.getLetter() != null ? currentEntry.getLetter().getCode() : null;
                    }
                }
            }
        }
        return result;
    }

    public void setFiscalPeriod(FiscalPeriod fiscalPeriod) {
        this.selectedFiscalPeriod = fiscalPeriod;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        boolean editableCell = false;
        Object currentRow = this.cacheDataList.get(rowIndex);
        if (currentRow instanceof Entry && columnIndex != 0 && columnIndex != 1) {
            editableCell = true;
        }
        if (currentRow instanceof FinancialTransaction && (columnIndex == 0 || columnIndex == 1)) {
            editableCell = true;
        }
        return editableCell;
    }

    public void addEmptyEntry(Object value, int row) throws LimaException {
        FinancialTransaction currentTransaction = null;
        Object currentRow = this.cacheDataList.get(row);
        EntryImpl entry = new EntryImpl();
        entry.setAmount(new BigDecimal(0));
        if (currentRow instanceof FinancialTransaction) {
            currentTransaction = (FinancialTransaction)currentRow;
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            currentTransaction = currentEntry.getFinancialTransaction();
        }
        entry.setFinancialTransaction(currentTransaction);
        this.financialTransactionService.createEntry((Entry)entry);
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        this.fireTableDataChanged();
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        int financialTransactionRow = 0;
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentFinancialTransaction = (FinancialTransaction)currentRow;
            switch (column) {
                case 0: {
                    currentFinancialTransaction.setTransactionDate((Date)value);
                    break;
                }
                case 1: {
                    currentFinancialTransaction.setEntryBook((EntryBook)value);
                }
            }
            try {
                this.financialTransactionService.updateFinancialTransaction(currentFinancialTransaction);
            }
            catch (LimaException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't update financial transaction", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            financialTransactionRow = this.cacheDataList.indexOf((FinancialTransaction)currentRow);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            switch (column) {
                case 2: {
                    currentEntry.setVoucher((String)value);
                    break;
                }
                case 3: {
                    currentEntry.setAccount((Account)value);
                    break;
                }
                case 4: {
                    currentEntry.setDescription((String)value);
                    break;
                }
                case 5: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(true);
                    break;
                }
                case 6: {
                    currentEntry.setAmount((BigDecimal)value);
                    currentEntry.setDebit(false);
                    break;
                }
                case 8: {
                    currentEntry.setLetter((Letter)value);
                }
            }
            try {
                this.financialTransactionService.updateEntry(currentEntry);
            }
            catch (LimaException eee) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't update entry", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            financialTransactionRow = this.cacheDataList.indexOf(((Entry)currentRow).getFinancialTransaction());
        }
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        this.fireTableDataChanged();
    }

    public Object getElementAt(int row) {
        Object currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    public void removeObject(Object object, int row) throws LimaException {
        Object currentRow = this.cacheDataList.get(row);
        if (currentRow instanceof FinancialTransaction) {
            FinancialTransaction currentTransaction = (FinancialTransaction)currentRow;
            this.financialTransactionService.removeFinancialTransaction(currentTransaction);
        } else if (currentRow instanceof Entry) {
            Entry currentEntry = (Entry)currentRow;
            this.financialTransactionService.removeEntry(currentEntry);
        }
        this.cacheDataList = this.getDataList(this.financialTransactionSearch);
        this.fireTableDataChanged();
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if ((serviceName.contains("FinancialTransaction") || methodeName.contains("importEntries") || methodeName.contains("importAll")) && !methodeName.contains("search")) {
            this.cacheDataList = this.getDataList(this.financialTransactionSearch);
            this.fireTableDataChanged();
        }
    }
}

