/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementreport;

import java.awt.Desktop;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaConfig;
import org.chorem.lima.beans.FinancialStatementAmounts;
import org.chorem.lima.business.DocumentServiceMonitorable;
import org.chorem.lima.business.FinancialStatementServiceMonitorable;
import org.chorem.lima.business.FinancialTransactionServiceMonitorable;
import org.chorem.lima.business.HttpServerServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.business.utils.DocumentsEnum;
import org.chorem.lima.business.utils.FormatsEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.util.ErrorHelper;
import org.nuiton.i18n.I18n;

public class FinancialStatementReportTableModel
extends AbstractTableModel
implements ServiceListener {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FinancialStatementReportTableModel.class);
    protected FinancialStatementServiceMonitorable financialStatementService = LimaServiceFactory.getInstance().getService(FinancialStatementServiceMonitorable.class);
    protected DocumentServiceMonitorable documentService;
    protected Date selectedBeginDate;
    protected Date selectedEndDate;
    protected int port;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected List<FinancialStatementAmounts> cacheDataList;

    public FinancialStatementReportTableModel() {
        this.financialStatementService.addListener((ServiceListener)this);
        this.port = LimaServiceFactory.getInstance().getService(HttpServerServiceMonitorable.class).getHttpPort();
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
        LimaServiceFactory.getInstance().getService(FinancialTransactionServiceMonitorable.class).addListener((ServiceListener)this);
        this.documentService = LimaServiceFactory.getInstance().getService(DocumentServiceMonitorable.class);
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.label");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.grossamount");
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.provisiondeprecationamount");
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.netamount");
            }
        }
        return res;
    }

    public Object getElementAt(int row) {
        FinancialStatementAmounts currentRow = this.cacheDataList.get(row);
        return currentRow;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = this.cacheDataList.get(row);
        if (result instanceof FinancialStatementAmounts) {
            BigDecimal provisionDeprecationAmount;
            FinancialStatementAmounts currentRow = result;
            BigDecimal grossAmount = currentRow.getGrossAmount();
            if (grossAmount == null) {
                grossAmount = new BigDecimal(0);
            }
            if ((provisionDeprecationAmount = currentRow.getProvisionDeprecationAmount()) == null) {
                provisionDeprecationAmount = new BigDecimal(0);
            }
            switch (column) {
                case 0: {
                    result = "";
                    String label = currentRow.getLabel();
                    if (label == null) break;
                    for (int i = 0; i <= currentRow.getLevel(); ++i) {
                        result = result + "\t";
                    }
                    result = result + label;
                    break;
                }
                case 1: {
                    if (grossAmount.doubleValue() == 0.0) {
                        result = null;
                        break;
                    }
                    result = grossAmount;
                    break;
                }
                case 2: {
                    if (provisionDeprecationAmount.doubleValue() == 0.0) {
                        result = null;
                        break;
                    }
                    result = provisionDeprecationAmount;
                    break;
                }
                case 3: {
                    BigDecimal solde = grossAmount.subtract(provisionDeprecationAmount);
                    result = solde.doubleValue() == 0.0 ? null : solde;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void setBeginDate(Date date) {
        this.selectedBeginDate = date;
    }

    public void setEndDate(Date date) {
        this.selectedEndDate = date;
    }

    public List<FinancialStatementAmounts> getDataList() {
        List results = null;
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            try {
                results = this.financialStatementService.financialStatementReport(this.selectedBeginDate, this.selectedEndDate);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.debug((Object)"Can't update model", (Throwable)eee);
                }
                ErrorHelper.showErrorDialog("Can't get entries list", eee);
            }
        }
        return results;
    }

    public void refresh() {
        this.cacheDataList = this.getDataList();
        this.fireTableDataChanged();
    }

    public void createDocument(FormatsEnum formatsEnum) {
        if (this.selectedBeginDate != null && this.selectedEndDate != null) {
            String address = LimaConfig.getInstance().getHostAdress();
            try {
                String url = "http://" + address + ":" + this.port + "/?beginDate=" + dateFormat.format(this.selectedBeginDate) + "&endDate=" + dateFormat.format(this.selectedEndDate) + "&format=" + formatsEnum.getExtension() + "&model=" + DocumentsEnum.FINANCIALSTATEMENT.getFileName();
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (IOException e) {
                log.error((Object)"Can't open browser", (Throwable)e);
            }
            catch (URISyntaxException e) {
                log.error((Object)"Can't create news URI", (Throwable)e);
            }
        }
    }

    public void notifyMethod(String serviceName, String methodeName) {
        if (serviceName.contains("FinancialTransaction") || methodeName.contains("FinancialStatement") || methodeName.contains("importAll")) {
            this.refresh();
        }
    }
}

