/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.financialstatementchart;

import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.FinancialStatementServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaBusinessException;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FinancialStatement;
import org.chorem.lima.entity.FinancialStatementImpl;
import org.chorem.lima.enums.FinancialStatementsChartEnum;
import org.chorem.lima.enums.ImportExportEnum;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartTreeTableModel;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementChartView;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementHeaderForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementImportForm;
import org.chorem.lima.ui.financialstatementchart.FinancialStatementMovementForm;
import org.chorem.lima.ui.importexport.ImportExport;
import org.chorem.lima.util.DialogHelper;
import org.chorem.lima.util.ErrorHelper;
import org.jdesktop.swingx.JXTreeTable;
import org.nuiton.i18n.I18n;

public class FinancialStatementChartViewHandler
implements ServiceListener {
    private static final Log log = LogFactory.getLog(FinancialStatementChartViewHandler.class);
    protected FinancialStatementServiceMonitorable financialStatementService;
    protected FinancialStatementChartView view;

    protected FinancialStatementChartViewHandler(FinancialStatementChartView view) {
        this.view = view;
        this.financialStatementService = LimaServiceFactory.getInstance().getService(FinancialStatementServiceMonitorable.class);
        LimaServiceFactory.getInstance().getService(ImportServiceMonitorable.class).addListener((ServiceListener)this);
    }

    public void addFinancialStatementHeader() {
        JXTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementHeader = new FinancialStatementImpl();
        FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
        financialStatementHeaderForm.setFinancialStatement((FinancialStatement)newFinancialStatementHeader);
        financialStatementHeaderForm.setLocationRelativeTo((Component)((Object)this.view));
        financialStatementHeaderForm.setVisible(true);
        newFinancialStatementHeader = financialStatementHeaderForm.getFinancialStatement();
        if (newFinancialStatementHeader != null) {
            newFinancialStatementHeader.setHeader(true);
            TreePath treePath = null;
            int selectedRow = treeTable.getSelectedRow();
            treePath = selectedRow != -1 ? treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            try {
                treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementHeader);
            }
            catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add financialStatementHeader", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            catch (LimaException ex) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add financialStatementHeader", (Throwable)ex);
                }
                ErrorHelper.showErrorDialog("Can't add financialStatementHeader", ex);
            }
        }
    }

    public void addFinancialStatementMovement() {
        JXTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        FinancialStatementImpl newFinancialStatementMovement = new FinancialStatementImpl();
        FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
        financialStatementMovementForm.setFinancialStatement((FinancialStatement)newFinancialStatementMovement);
        financialStatementMovementForm.setLocationRelativeTo((Component)((Object)this.view));
        financialStatementMovementForm.setVisible(true);
        newFinancialStatementMovement = financialStatementMovementForm.getFinancialStatement();
        if (newFinancialStatementMovement != null) {
            TreePath treePath = null;
            int selectedRow = this.view.treeTable.getSelectedRow();
            treePath = this.view.treeTable.getPathForRow(selectedRow);
            try {
                treeTableModel.addFinancialStatement(treePath, (FinancialStatement)newFinancialStatementMovement);
            }
            catch (LimaBusinessException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add FinancialStatementMovement", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't add FinancialStatementMovement", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void updateFinancialStatement() {
        JXTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
        FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
        if (financialStatement != null) {
            treePath = selectedRow != -1 ? this.view.treeTable.getPathForRow(selectedRow) : new TreePath(treeTableModel.getRoot());
            log.debug((Object)financialStatement.getHeader());
            if (financialStatement.getHeader()) {
                FinancialStatementHeaderForm financialStatementHeaderForm = new FinancialStatementHeaderForm((JAXXContext)this.view);
                financialStatementHeaderForm.setFinancialStatement(financialStatement);
                financialStatementHeaderForm.setLocationRelativeTo((Component)((Object)this.view));
                financialStatementHeaderForm.setVisible(true);
                financialStatement = financialStatementHeaderForm.getFinancialStatement();
            } else {
                FinancialStatementMovementForm financialStatementMovementForm = new FinancialStatementMovementForm((JAXXContext)this.view);
                financialStatementMovementForm.setFinancialStatement(financialStatement);
                financialStatementMovementForm.setLocationRelativeTo((Component)((Object)this.view));
                financialStatementMovementForm.setVisible(true);
                financialStatement = financialStatementMovementForm.getFinancialStatement();
            }
            if (financialStatement != null) {
                try {
                    treeTableModel.updateFinancialStatement(treePath, financialStatement);
                }
                catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't add update", (Throwable)eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
    }

    public void removeFinancialStatement() {
        int n;
        JXTreeTable treeTable = this.view.getTreeTable();
        FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
        int selectedRow = this.view.treeTable.getSelectedRow();
        if (selectedRow != -1 && (n = JOptionPane.showConfirmDialog((Component)((Object)this.view), I18n._((String)"lima.charts.account.question.remove"), I18n._((String)"lima.common.confirmation"), 0, 3)) == 0) {
            TreePath treePath = this.view.treeTable.getPathForRow(selectedRow);
            FinancialStatement financialStatement = (FinancialStatement)treePath.getLastPathComponent();
            try {
                treeTableModel.removeFinancialStatementObject(treePath, financialStatement);
            }
            catch (LimaException eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't delete account", (Throwable)eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
            }
        }
    }

    public void refresh() {
        block2: {
            JXTreeTable treeTable = this.view.getTreeTable();
            FinancialStatementChartTreeTableModel treeTableModel = (FinancialStatementChartTreeTableModel)treeTable.getTreeTableModel();
            try {
                treeTableModel.refreshTree();
            }
            catch (LimaException eee) {
                if (!log.isDebugEnabled()) break block2;
                log.debug((Object)"Can't refresh model", (Throwable)eee);
            }
        }
        this.view.repaint();
    }

    public void importFinancialStatementChart() {
        FinancialStatementImportForm form = new FinancialStatementImportForm();
        form.setLocationRelativeTo((Component)((Object)this.view));
        form.setVisible(true);
        Object value = form.getRadioButtons().getSelectedValue();
        if (value != null) {
            block4: {
                if (form.getDeleteFinancialStatementChart().isSelected()) {
                    try {
                        this.financialStatementService.removeAllFinancialStatement();
                    }
                    catch (LimaException eee) {
                        if (!log.isDebugEnabled()) break block4;
                        log.debug((Object)"Can't delete financial statement chart", (Throwable)eee);
                    }
                }
            }
            FinancialStatementsChartEnum defaultFinancialStatementsEnum = (FinancialStatementsChartEnum)((Object)value);
            ImportExport importExport = ImportExport.getInstance((Component)((Object)this.view));
            importExport.importExport(ImportExportEnum.CSV_FINANCIALSTATEMENTS_IMPORT, defaultFinancialStatementsEnum.getFilePath(), true);
        }
    }

    public void financialStatementChartCheck() {
        try {
            String result = this.financialStatementService.checkFinancialStatementChart();
            DialogHelper.showReportDialog(result, I18n._((String)"lima.financialstatement.check"), (Component)((Object)this.view));
        }
        catch (LimaException e) {
            log.error((Object)"Can't check financialstatement chart", (Throwable)e);
        }
    }

    public void notifyMethod(String serviceName, String methodName) {
        if (methodName.contains("FinancialStatements") || methodName.contains("importAll") || methodName.contains("importAs")) {
            this.refresh();
        }
    }
}

