/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.celleditor;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Date;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.chorem.lima.LimaContext;
import org.jdesktop.swingx.JXDatePicker;

public class DateTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private final JXDatePicker datePicker = new JXDatePicker(LimaContext.getContext().getConfig().getLocale());
    private static final long serialVersionUID = 1L;
    private static DateTableCellEditor editor;

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof Date) {
            this.datePicker.setDate((Date)value);
        }
        return this.datePicker;
    }

    @Override
    public Object getCellEditorValue() {
        return this.datePicker.getDate();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return !(evt instanceof MouseEvent) || ((MouseEvent)evt).getClickCount() == 2;
    }

    public static DateTableCellEditor getInstance() {
        if (editor == null) {
            editor = new DateTableCellEditor();
        }
        return editor;
    }
}

