/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.lima.ui.balance;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.BalanceTrial;
import org.chorem.lima.beans.ReportsDatas;
import org.nuiton.i18n.I18n;

public class BalanceTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(BalanceTableModel.class);
    protected BalanceTrial cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.cacheDataList != null) {
            result = this.cacheDataList.getReportsDatas().size();
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 6;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0: {
                res = I18n._((String)"lima.table.number");
                break;
            }
            case 1: {
                res = I18n._((String)"lima.table.label");
                break;
            }
            case 2: {
                res = I18n._((String)"lima.table.move.debit");
                break;
            }
            case 3: {
                res = I18n._((String)"lima.table.move.credit");
                break;
            }
            case 4: {
                res = I18n._((String)"lima.table.solde.debit");
                break;
            }
            case 5: {
                res = I18n._((String)"lima.table.solde.credit");
            }
        }
        return res;
    }

    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        ReportsDatas currentRow = (ReportsDatas)((List)this.cacheDataList.getReportsDatas()).get(row);
        try {
            switch (column) {
                case 0: {
                    result = currentRow.getAccount().getAccountNumber();
                    break;
                }
                case 1: {
                    result = currentRow.getAccount().getLabel();
                    break;
                }
                case 2: {
                    result = currentRow.getAmountDebit();
                    break;
                }
                case 3: {
                    result = currentRow.getAmountCredit();
                    break;
                }
                case 4: {
                    if (currentRow.getSoldeDebit()) {
                        result = currentRow.getAmountSolde();
                        break;
                    }
                    result = 0;
                    break;
                }
                case 5: {
                    result = !currentRow.getSoldeDebit() ? currentRow.getAmountSolde() : Integer.valueOf(0);
                }
            }
        }
        catch (Exception eee) {
            log.debug((Object)"Can't get entries", (Throwable)eee);
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void refresh(BalanceTrial datasList) {
        this.cacheDataList = datasList;
        this.fireTableDataChanged();
    }
}

