/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.util;

import org.chorem.lima.entity.EntryBook;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class EntryBookToString extends ObjectToStringConverter{

    private static EntryBookToString converter;
	
	@Override
	public String getPreferredStringForItem(Object item) {
		String result = null;
		if (item != null){
			if (item instanceof EntryBook){
				EntryBook entryBook = (EntryBook) item;
				result = entryBook.getCode()+" - "+entryBook.getLabel();	
			}
		}
		return result;
	}
	
	
    public static EntryBookToString getInstance() {
        if (converter == null) {
        	converter = new EntryBookToString();
        }
        return converter;
    }
}
