/*
 * *##% Lima Main
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%*
 */

package org.chorem.lima.ui.ledger;

import static org.nuiton.i18n.I18n._;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.beans.ReportsDatas;
import org.chorem.lima.entity.Entry;

/**
 * Entry book table model.
 * 
 * @author ore
 * @author chatellier
 * @version $Revision: 2865 $
 * 
 * Last update : $Date: 2010-04-19 15:19:30 +0200 (lun. 19 avril 2010) $
 * By : $Author: jpepin $
 */
public class LedgerTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 1L;

    /** log. */
    private static final Log log = LogFactory.getLog(LedgerTableModel.class);
    
    /** data cache */
    protected List<Object> cacheDataList;

    @Override
    public int getRowCount() {
        int result = 0;
        
        // just prevent too much result
        if (cacheDataList != null) {
            result = cacheDataList.size();
        }

        return result;
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    public String getColumnName(int column) {
        String res = "n/a";
        switch (column) {
            case 0:
                res = _("lima.table.account"); //Account
                break;
            case 1:
                res = _("lima.table.date"); //Date
                break;
            case 2:
                res = _("lima.table.entrybook");
                break;
            case 3:
                res = _("lima.table.voucher"); // Voucher
                break;
            case 4:
                res = _("lima.table.description"); //Description
                break;
            case 5:
                res = _("lima.table.debit"); //Debit
                break;
            case 6:
                res = _("lima.table.credit"); //Credit
                break;
            case 7:
                res = _("lima.table.solde");
                break;
        }
        return res;
    }
    
    @Override
    public Object getValueAt(int row, int column) {
        Object result = null;
        
        // just prevent too much result
        if (cacheDataList != null) {
            result = cacheDataList.get(row);
            SimpleDateFormat simpleDateFormat
            = new SimpleDateFormat("dd MMMMM yyyy");
            
            if (result instanceof ReportsDatas) {
                ReportsDatas currentRow = (ReportsDatas)result; 
                BigDecimal amountDebit = currentRow.getAmountDebit();
                BigDecimal amountCredit = currentRow.getAmountCredit();
                
                switch (column) {
                case 0:
                    if (currentRow.getAccount() != null){
                        result = currentRow.getAccount().getAccountNumber();
                    }
                    else {
                        result = null;
                    }
                    break;
                case 1:
                    result = null; // date
                    break;
                case 2:
                    result = null; //entrybook
                    break;
                case 3:
                    result = null; // voucher
                    break;
                case 4:
                    result = null; // description
                    break;
                case 5 :
                    result = amountDebit; // position
                    break;
                case 6:
                    result = amountCredit; 
                    break;
                case 7:
                    result =  amountDebit.subtract(amountCredit);
                    break;
                }
            }
            else if (result instanceof Entry) {
                Entry currentRow = (Entry)result;
                BigDecimal amountDebit = new BigDecimal(0),
                		   amountCredit = new BigDecimal(0);
                if (currentRow.getDebit()){
                	amountDebit = currentRow.getAmount();
                }
                else {
                	amountCredit = currentRow.getAmount();
                }

                switch (column) {
                case 0:
                    result = null; // account
                    break;
                case 1 : // date
                    result = simpleDateFormat.
                    format(currentRow.getFinancialTransaction().getTransactionDate());
                    break;
                case 2:
                    if (currentRow.getFinancialTransaction().getEntryBook() != null){
                        result = currentRow.getFinancialTransaction().getEntryBook().getCode();
                    }
                    else { //entrybook
                        result = null;
                    }
                    break;
                case 3: // description
                    result = currentRow.getVoucher();
                    break;
                case 4:
                    result = currentRow.getDescription();
                    break;
                case 5 :
                    result = amountDebit;
                    break;
                case 6:
                    result = amountCredit; 
                    break;
                case 7:
                    result = amountDebit.subtract(amountCredit);
                    break;
                }
                
            }
        }
        return result;
    }
    

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        // Just read, no write
        return false;
    }
    
    
    public void refresh(List<Object> datasList){
        cacheDataList = datasList;
        fireTableDataChanged();
    }
    
}
