/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.ledger;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;


/**
 * Table des transaction qui ajoute des comportement (keys).
 * 
 * @author ore
 * @author Rémi Chapelet
 */
public class LedgerTable extends JXTable {

    /** serialVersionUID. */
    private static final long serialVersionUID = 3133690382049594727L;

    protected LedgerViewHandler handler;
    
    private Highlighter colorReportsDatas;

    /**
     */
    public LedgerTable(LedgerViewHandler handler) {

        this.handler = handler;
        //highlight financial financial transactions
        addColorReportsDatas();

    }

    /**
     * Cette méthode permet de colorer toutes les reportsdatas dans le tableau
     * afin de bien distinguer les entête de comptes et les entrées comptables.
     * On récupère la première cellule, on vérifie que c'est pas null
     */
   protected void addColorReportsDatas() {
       if (colorReportsDatas != null) {
           removeHighlighter(colorReportsDatas);
       }
       HighlightPredicate predicate = new HighlightPredicate() {
           @Override
           public boolean isHighlighted(Component renderer,
                   ComponentAdapter adapter) {
               return (adapter.getValueAt(adapter.row, 0) != null);
           }
       };
       colorReportsDatas =
            new ColorHighlighter(predicate, new Color(222,222,222), null);
        addHighlighter(colorReportsDatas);
    }
}
