/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.home;

import static org.nuiton.i18n.I18n._;
import java.awt.Color;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.basic.BasicEditorPaneUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.LimaContext;
import org.chorem.lima.business.FiscalPeriodServiceMonitorable;
import org.chorem.lima.business.ImportServiceMonitorable;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.business.ServiceListener;
import org.chorem.lima.entity.FiscalPeriod;
import org.chorem.lima.service.LimaServiceFactory;
import org.chorem.lima.ui.MainView;

public class FiscalPeriodsPane extends JEditorPane implements HyperlinkListener, ServiceListener {

	private static final long serialVersionUID = 1L;
	
    private static final Log log = LogFactory.getLog(FiscalPeriodsPane.class);
    
    protected HomeView view;
	
	protected FiscalPeriodServiceMonitorable fiscalPeriodService;
	
    private static Color redBackground = new Color(0xff, 0xee, 0xee);
    private static Color greenBackground = new Color(0xee, 0xff, 0xee);
    
    public FiscalPeriodsPane(HomeView view) {
    	this.view = view;
    	
        fiscalPeriodService =
        	LimaServiceFactory.getInstance().getService(FiscalPeriodServiceMonitorable.class);
    	fiscalPeriodService.addListener(this);
    	LimaServiceFactory.getInstance().getService(
    			ImportServiceMonitorable.class).addListener(this);
    	
    	//init
    	setOpaque(true);
    	setContentType("text/html");
    	setEditable(false);
    	setUI(new BasicEditorPaneUI());
    	addHyperlinkListener(this);
    	refresh();	}
	
	@Override
	public void hyperlinkUpdate(HyperlinkEvent e) {
		if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
			
			if (e.getDescription().equals("#fiscalperiodschart")) {
		        MainView ui = LimaContext.MAIN_UI_ENTRY_DEF.getContextValue(view);
		        ui.getHandler().showFiscalPeriodView(ui);
			}
		}
	}
	
public void refresh(){
    	
    	String htmlBegin = "<font face='sans-serif' size=3>"
    		+ "<p style=vertical-align:'bottom', horizontal-align:'center'>";
    	String htmlEnd = "</p></font>";
    	    	
    	try {
			
			//FISCAL PERIOD
			List<FiscalPeriod> fiscalPeriods =
				fiscalPeriodService.getAllFiscalPeriods();
			List<FiscalPeriod> unblockedFiscalPeriods =
				fiscalPeriodService.getAllUnblockedFiscalPeriods();
			if (unblockedFiscalPeriods.size()>0){
				setBackground(greenBackground);
		    	String fiscalString = unblockedFiscalPeriods.size() + " "
		    		+ _("lima.home.fiscalperiod.opened") + "<br/>"
		    		+ (fiscalPeriods.size()-unblockedFiscalPeriods.size())
		    		+ " " + _("lima.home.fiscalperiod.closed")
		    		+ "<br/><br/><a href='#fiscalperiodschart'>"
		    		+ _("lima.home.fiscalperiod.modify") + "</a>";
		    	//set Text
		    	setText(htmlBegin + fiscalString + htmlEnd);
				
				
			}
			else {
				setBackground(redBackground);
		    	String fiscalString = _("lima.home.fiscalperiod.noopen");
		    	if (fiscalPeriods.size()>0){
		    		fiscalString += "<br/>" + fiscalPeriods.size() + " "
		    		+ _("lima.home.fiscalperiod.closed");
		    	}
		    	fiscalString += "<br/><br/><a href='#fiscalperiodschart'>"
		    		+ _("lima.home.fiscalperiod.create") + "</a>";
		    	//set Text
		    	setText(htmlBegin + fiscalString + htmlEnd);

			}
		} catch (LimaException eee) {
			log.debug("Can't get datas home", eee);
		}
    }

	@Override
	public void notifyMethod(String serviceName, String methodeName) {
		if (methodeName.contains("FiscalPeriod") || methodeName.contains("importAll")
				|| methodeName.contains("importAs")){
			refresh();
		}		
	}

}
