/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialtransaction;

import static org.nuiton.i18n.I18n._;


import javax.swing.JOptionPane;
import javax.swing.ListSelectionModel;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.Entry;
import org.chorem.lima.entity.FinancialTransaction;
import org.chorem.lima.ui.combobox.FinancialPeriodComboBoxModel;
import org.chorem.lima.ui.combobox.FiscalPeriodComboBoxModel;
import org.chorem.lima.ui.financialtransaction.FinancialTransactionView;
import org.chorem.lima.util.DialogHelper;

/**
 * Handler associated with financial transaction view.
 * 
 * @author chatellier
 * @version $Revision: 3015 $
 * 
 * Last update : $Date: 2010-08-23 18:38:53 +0200 (Lun, 23 aoû 2010) $
 * By : $Author: jpepin $
 */
public class FinancialTransactionViewHandler {

    /** log. */
    private static final Log log =
        LogFactory.getLog(FinancialTransactionViewHandler.class);

    protected FinancialTransactionView view;
    
    protected FinancialTransactionTable table;
    
    protected FinancialTransactionTableModel tableModel;
    
    protected FiscalPeriodComboBoxModel fiscalPeriodComboBoxModel;
    
    protected FinancialPeriodComboBoxModel financialPeriodComboBoxModel;
    
    protected Object clipBoard;

    protected FinancialTransactionViewHandler(FinancialTransactionView view) {
        this.view = view;
    }    
    
    //copy entry 
    public void copyRow(){
    	table = view.getFinancialTransactionTable();
    	int indexSelectedRow = table.getSelectedRow();
    	
        if (indexSelectedRow != -1) {
            clipBoard = tableModel.getElementAt(indexSelectedRow);
        }
    }
    
    //paste entry
    public void pasteRow(){
    	table = view.getFinancialTransactionTable();
    	int indexSelectedRow = table.getSelectedRow();
    	
        if (indexSelectedRow != -1) {
            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
        	if (clipBoard instanceof Entry) {
	            try {
	        		tableModel.addEntry(selectedValue, (Entry) clipBoard, indexSelectedRow);
	        	    //select the new line
	        	    ListSelectionModel selectionModel = 
	        	        table.getSelectionModel();
	        	      selectionModel.setSelectionInterval(
	        	    		  indexSelectedRow+1, indexSelectedRow+1);
	                  //focus on second column
	                  table.changeSelection(indexSelectedRow+1, 1, false, false);
	                  table.requestFocusInWindow();
	        	} catch (LimaException eee){
	                if (log.isErrorEnabled()) {
	                    log.error("Can't past entry", eee);
	                }
	                DialogHelper.showMessageDialog(eee.getMessage());
	        	}
        	}

        }
    	
    }
    
    //add a new transaction
    public void addFinancialTransaction() {
        table = view.getFinancialTransactionTable();
        tableModel = view.getFinancialTransactionTableModel();

        try {
        	tableModel.addFinancialTransaction();
            //select the new line
            int numberRow = table.getRowCount();
            ListSelectionModel selectionModel = 
                table.getSelectionModel();
            selectionModel.setSelectionInterval(numberRow-1, numberRow-1);
            //focus on first column
            table.changeSelection(numberRow-1, 0, false, false);
            table.requestFocusInWindow();
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't add financialtransaction", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }
    
    //implement new transaction button
    //add a new entry to the selected transaction
    public void addEmptyEntry(){
        
        table = view.getFinancialTransactionTable();
        tableModel = view.getFinancialTransactionTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {
        	Object selectedValue = tableModel.getElementAt(indexSelectedRow);
        	try {
        		tableModel.addEmptyEntry(selectedValue, indexSelectedRow);
        	    //select the new line
        	    ListSelectionModel selectionModel = 
        	        table.getSelectionModel();
        	      selectionModel.setSelectionInterval(
        	    		  indexSelectedRow+1, indexSelectedRow+1);
                  //focus on second column
                  table.changeSelection(indexSelectedRow+1, 1, false, false);
                  table.requestFocusInWindow();
        	} catch (LimaException eee){
                if (log.isErrorEnabled()) {
                    log.error("Can't add emptyentry", eee);
                }
                DialogHelper.showMessageDialog(eee.getMessage());
        	}
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call addentry selected transaction without selection");
            }
        }
    }
    
    /**
     * Delete selected row in table (could be transaction or entry).
     * 
     * Called by model.
     * @throws LimaException 
     */
    public void deleteSelectedRow(){

        table = view.getFinancialTransactionTable();
        tableModel = view.getFinancialTransactionTableModel();

        int indexSelectedRow = table.getSelectedRow();
        if (indexSelectedRow != -1) {

            Object selectedValue = tableModel.getElementAt(indexSelectedRow);
            String message = null;
            if (selectedValue instanceof FinancialTransaction) {
                message = _("lima.charts.financialtransaction.question.removetransaction");
            }
            else {
                message = _("lima.charts.financialtransaction.question.removeentry");
            }

            int response = JOptionPane.showConfirmDialog(view, message,
                    _("lima.common.confirmation"), JOptionPane.YES_NO_OPTION);

            if (response == JOptionPane.YES_OPTION) {
            	
                try {
                	tableModel.removeObject(selectedValue, indexSelectedRow);
                    //select the upper line
                    ListSelectionModel selectionModel = 
                        table.getSelectionModel();
                    selectionModel.setSelectionInterval(
                    		indexSelectedRow-1, indexSelectedRow-1);
                } catch (LimaException eee) {
                    if (log.isErrorEnabled()) {
                        log.error("Can't remove transaction or entry", eee);
                    }
                    DialogHelper.showMessageDialog(eee.getMessage());
                }
            }
        }
        else {
            if (log.isWarnEnabled()) {
                log.warn("Call delete selected row without selection");
            }
        }
    }
    
    public void refresh(){
        tableModel = view.getFinancialTransactionTableModel();
        tableModel.refresh();        
        fiscalPeriodComboBoxModel = view.getModelFiscalPeriod();
        fiscalPeriodComboBoxModel.refresh();
        
        financialPeriodComboBoxModel = view.getModelFinancialPeriod();
        financialPeriodComboBoxModel.refresh();
    }
}
