/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialstatementreport;

import java.awt.Color;
import java.awt.Component;
import org.chorem.lima.beans.FinancialStatementAmounts;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;


public class FinancialStatementReportTable extends JXTable {
	
	private static final long serialVersionUID = 154211277688304679L;

	protected FinancialStatementReportViewHandler handler;
    
    protected FinancialStatementReportTableModel model;
        
    private Highlighter colorTransaction;
    
    /*
     * Constructor, call highlighter
     */
    public FinancialStatementReportTable(FinancialStatementReportViewHandler handler) {
    	super(handler.getView().modelTable);
        this.handler = handler;
        model = this.handler.getView().modelTable;

        //highlight financial financial transactions
        colorTitle1();
        colorTitle2();
                
        //Renderer for font
        FinancialStatementReportTableCellRenderer renderer = new FinancialStatementReportTableCellRenderer();
        for (int i = 0; i < getColumnModel().getColumnCount(); i++) {
        	getColumnModel().getColumn(i).setCellRenderer(renderer);
        }
    }

    /*
     * Color the background row in grey if the level is 1
     */
    protected void colorTitle1() {
    	
    	
       HighlightPredicate predicate = new HighlightPredicate() {
            @Override
            public boolean isHighlighted(Component renderer,
                    ComponentAdapter adapter) {
            	Boolean result = false;
	        	Object object = model.getElementAt(adapter.row);
	            if (model.getElementAt(adapter.row) instanceof FinancialStatementAmounts){
	            	FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;
	            	result = financialStatementAmounts.getLevel() == 1;
	            }
                return result;
            }
        };
         colorTransaction =
             new ColorHighlighter(predicate, new Color(222,222,222), null);
         addHighlighter(colorTransaction);
     }
    
    /*
     * Color the background in light grey if is a subamount
     */
    protected void colorTitle2() {
    	
    	
        HighlightPredicate predicate = new HighlightPredicate() {
             @Override
             public boolean isHighlighted(Component renderer,
                     ComponentAdapter adapter) {
             	Boolean result = false;
 	        	Object object = model.getElementAt(adapter.row);
 	            if (model.getElementAt(adapter.row) instanceof FinancialStatementAmounts){
 	            	FinancialStatementAmounts financialStatementAmounts = (FinancialStatementAmounts) object;
 	            	result = financialStatementAmounts.getSubAmount();
 	            }
                 return result;
             }
         };
          colorTransaction =
              new ColorHighlighter(predicate, new Color(244,244,244), null);
          addHighlighter(colorTransaction);
      }

}
