/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.ui.financialperiod;

import static org.nuiton.i18n.I18n._;

import javax.swing.JOptionPane;

import org.jdesktop.swingx.JXTable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.lima.business.LimaException;
import org.chorem.lima.entity.ClosedPeriodicEntryBook;
import org.chorem.lima.util.DialogHelper;

/**
 * TODO add comment here.
 * 
 * @author chatellier
 * @version $Revision: 2872 $
 * 
 * Last update : $Date: 2010-04-23 16:40:13 +0200 (ven. 23 avril 2010) $
 * By : $Author: jpepin $
 */
public class FinancialPeriodViewHandler {

    private static final Log log = LogFactory.getLog(FinancialPeriodViewHandler.class);
    
    protected FinancialPeriodView view;
    
    protected FinancialPeriodViewHandler(FinancialPeriodView view) {
        this.view = view;
    }

    public void blockFinancialPeriod() {
        JXTable financialPeriodeTable = view.getFinancialPeriodTable();
        int selectedRow = financialPeriodeTable.getSelectedRow();
        FinancialPeriodTableModel model = (FinancialPeriodTableModel)view.getFinancialPeriodTable().getModel();
        
        // blocked it
        try {
            ClosedPeriodicEntryBook closedPeriodicEntryBook = model.getFinancialPeriodAtRow(selectedRow);
            int response = JOptionPane.showConfirmDialog(view, _("lima.charts.financialperiod.question.blocked"),
                    _("lima.common.question"), JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);

            if (response == JOptionPane.YES_OPTION) {
                model.blockFinancialPeriod(closedPeriodicEntryBook);
            }
        } catch (LimaException eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't block financialperiod", eee);
            }
            DialogHelper.showMessageDialog(eee.getMessage());
        }
    }
    
    public FinancialPeriodView getView() {
        return view;
    }
}
