/* *##% Lima Swing
 * Copyright (C) 2008 - 2010 CodeLutin
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * ##%*/

package org.chorem.lima.enums;

import static org.nuiton.i18n.I18n._;


public enum ComboBoxOperatorsEnum {

	EQUAL(_("lima.enum.comboboxoperator.equal"), "="),
	SUPERIOR_OR_EQUAL(_("lima.enum.comboboxoperator.superiororequal"), ">="),
	INFERIOR_OR_EQUAL(_("lima.enum.comboboxoperator.inferiororequal"), "<="),
	SUPERIOR(_("lima.enum.comboboxoperator.superior"), ">"),
	INFERIOR(_("lima.enum.comboboxoperator.inferior"), "<"),
	INTERVAL(_("lima.enum.comboboxoperator.interval"), ""),
	NOT_EQUAL(_("lima.enum.comboboxoperator.notequal"),"!=");
	
	private final String description;
	private final String symbol;
	
	private ComboBoxOperatorsEnum(String description, String symbol) {
		this.description = description;
		this.symbol = symbol;
	}
	
	public String getDescription() {
		return this.description;
	}
	
	public String getSymbol(){
		return this.symbol;
	}
	
	public static String[] descriptions(){
		int nbElts = ComboBoxOperatorsEnum.values().length;
		String[] descriptions = new String[nbElts];
		ComboBoxOperatorsEnum[] enums = ComboBoxOperatorsEnum.values();
		for (int i = 0; i < nbElts; i++) {
			descriptions[i] = enums[i].getDescription();
		}
		return descriptions;
	}

	
	public static ComboBoxOperatorsEnum valueOfDescription(String description){
		ComboBoxOperatorsEnum value = null;
		
		for (ComboBoxOperatorsEnum enums : ComboBoxOperatorsEnum.values()) {
			if (description.equals(enums.description)){
				value = enums;
				break;
			}
		}
		return value;
	}
}
