/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.Set;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

public abstract class ToolboxMojoSupport
extends AbstractPlugin {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${project.basedir}/src/main/resources", required=true)
    private File sourceRoot;
    private Path outputFile;

    protected void init() throws Exception {
        if (this.isSkip()) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.outputFile = this.createOutputFile();
    }

    protected abstract Path createOutputFile() throws IOException;

    protected abstract boolean isSkip();

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public File getSourceRoot() {
        return this.sourceRoot;
    }

    public Path getOutputFile() {
        return this.outputFile;
    }

    public Path getSourceRootPath() {
        return this.getSourceRoot().toPath();
    }

    void generate(String packageName, String className, String prefix, Set<String> fields, Path outputFile) throws IOException {
        try (BufferedWriter writer = Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]);){
            writer.write("// Generated by " + ((Object)((Object)this)).getClass().getName() + " at " + new Date() + "\n");
            writer.write("package " + packageName + ";\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("import static org.nuiton.i18n.I18n.n;\n");
            writer.write("\n");
            writer.write("\n");
            writer.write("public class " + className + " {\n");
            writer.write("\n    static {");
            writer.write("\n");
            for (String typeName : fields) {
                writer.write("        n(\"" + prefix + typeName + "\");\n");
            }
            writer.write("\n");
            writer.write("    }\n");
            writer.write("\n");
            writer.write("}\n");
        }
    }
}

