/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import fr.ird.observe.maven.plugins.toolbox.MismatchMethodParameterNameException;
import fr.ird.observe.maven.plugins.toolbox.MissingClassException;
import fr.ird.observe.maven.plugins.toolbox.MissingMethodException;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.nuiton.plugin.AbstractPlugin;

@Mojo(name="check-api", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class CheckApiMojo
extends AbstractPlugin {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    @Parameter(property="checkApi.sourceApiRootDirectory", required=true, defaultValue="${project.build.sourceDirectory}")
    protected File sourceApiRootDirectory;
    @Parameter(property="checkApi.sourceApiPackageName", required=true)
    protected String sourceApiPackageName;
    @Parameter(property="checkApi.sourceApiIncludePattern", required=true)
    protected String sourceApiIncludePattern;
    @Parameter(property="checkApi.targetApiPackageName", required=true)
    protected String targetApiPackageName;
    @Parameter(property="checkApi.targetApiClassSuffix", required=true)
    protected String targetApiClassSuffix;
    @Parameter(property="checkApi.verbose", defaultValue="${maven.verbose}")
    protected boolean verbose;
    @Parameter(property="checkApi.skip", defaultValue="false")
    protected boolean skip;
    @Parameter(property="checkApi.encoding", defaultValue="${project.build.sourceEncoding}", required=true)
    protected String encoding;
    protected Map<ClassPath.ClassInfo, ClassPath.ClassInfo> translationMap;
    private int methodCount;

    protected void init() throws Exception {
        if (this.skip) {
            return;
        }
        if (this.getLog().isDebugEnabled()) {
            this.setVerbose(true);
        }
        Pattern sourceNameMatchingPattern = Pattern.compile(this.sourceApiIncludePattern);
        URLClassLoader cl = this.initClassLoader(this.project, this.sourceApiRootDirectory, false, true, false, true, true);
        ImmutableSet sourceApiClassesInPackage = ClassPath.from((ClassLoader)cl).getTopLevelClassesRecursive(this.sourceApiPackageName);
        ImmutableSet targetApiClassesInPackage = ClassPath.from((ClassLoader)cl).getTopLevelClassesRecursive(this.targetApiPackageName);
        ImmutableMap targetClassInfosByClassName = Maps.uniqueIndex((Iterable)targetApiClassesInPackage, ClassPath.ClassInfo::getName);
        LinkedHashMap<ClassPath.ClassInfo, ClassPath.ClassInfo> translationMap = new LinkedHashMap<ClassPath.ClassInfo, ClassPath.ClassInfo>();
        for (ClassPath.ClassInfo sourceClassInfo : sourceApiClassesInPackage) {
            Matcher matcher = sourceNameMatchingPattern.matcher(sourceClassInfo.getSimpleName());
            if (!matcher.matches()) continue;
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Found maching source class: " + sourceClassInfo));
            }
            String sourceName = sourceClassInfo.getName();
            String sourceSimpleNameName = sourceClassInfo.getSimpleName();
            String sourcePackageNameSuffix = sourceName.substring(this.sourceApiPackageName.length() + 1, sourceName.length() - sourceSimpleNameName.length());
            String targetPackageName = sourcePackageNameSuffix.isEmpty() ? this.targetApiPackageName : this.targetApiPackageName + "." + sourcePackageNameSuffix.substring(0, sourcePackageNameSuffix.length() - 1);
            String targetSimpleName = sourceSimpleNameName + this.targetApiClassSuffix;
            String targetName = targetPackageName + "." + targetSimpleName;
            ClassPath.ClassInfo targetClassInfo = !targetClassInfosByClassName.containsKey((Object)targetName) ? null : (ClassPath.ClassInfo)targetClassInfosByClassName.get((Object)targetName);
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Found maching class to check : " + sourceClassInfo + " \u2192 " + targetClassInfo));
            }
            translationMap.put(sourceClassInfo, targetClassInfo);
        }
        this.translationMap = Collections.unmodifiableMap(translationMap);
        this.getLog().info((CharSequence)(translationMap.size() + " type(s) detected."));
    }

    protected boolean checkSkip() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping goal (skip flag is on).");
            return false;
        }
        if (this.translationMap.isEmpty()) {
            this.getLog().warn((CharSequence)"Skipping goal (No matching class).");
            return false;
        }
        return super.checkSkip();
    }

    public void doAction() throws Exception {
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("project = " + this.project));
        }
        for (Map.Entry<ClassPath.ClassInfo, ClassPath.ClassInfo> entry : this.translationMap.entrySet()) {
            ClassPath.ClassInfo sourceClassInfo = entry.getKey();
            ClassPath.ClassInfo targetClassInfo = entry.getValue();
            Class sourceClass = sourceClassInfo.load();
            Class targetClass = targetClassInfo == null ? null : targetClassInfo.load();
            this.checkClass(sourceClass, targetClass);
        }
        this.getLog().info((CharSequence)(this.translationMap.size() + " class(es) checked."));
        this.getLog().info((CharSequence)(this.methodCount + " method(s) checked."));
    }

    public MavenProject getProject() {
        return this.project;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    private void checkClass(Class<?> sourceClass, Class<?> targetClass) throws MissingMethodException, MismatchMethodParameterNameException, MissingClassException {
        Method[] sourceDeclaredMethods = sourceClass.getDeclaredMethods();
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("Check " + sourceClass.getName()));
        }
        if (targetClass == null) {
            throw new MissingClassException(sourceClass.getName());
        }
        for (Method sourceMethod : sourceDeclaredMethods) {
            Method targetMethod;
            ++this.methodCount;
            try {
                targetMethod = targetClass.getDeclaredMethod(sourceMethod.getName(), sourceMethod.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new MissingMethodException("Could not find method " + sourceMethod.getName() + " on target class: " + targetClass);
            }
            if (this.isVerbose()) {
                this.getLog().info((CharSequence)("Check " + sourceClass.getName() + "#" + sourceMethod.getName()));
            }
            java.lang.reflect.Parameter[] sourceParameters = sourceMethod.getParameters();
            java.lang.reflect.Parameter[] targetParameters = targetMethod.getParameters();
            int max = sourceParameters.length;
            for (int i = 0; i < max; ++i) {
                java.lang.reflect.Parameter sourceParameter = sourceParameters[i];
                java.lang.reflect.Parameter targetParameter = targetParameters[i];
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Check " + sourceClass.getName() + "#" + sourceMethod.getName() + "\u2192" + sourceParameter.getName() + " vs " + targetParameter.getName()));
                }
                if (sourceParameter.getName().equals(targetParameter.getName())) continue;
                throw new MismatchMethodParameterNameException(sourceClass.getName(), sourceMethod.getName(), sourceParameter.getName(), i, targetClass.getName(), targetMethod.getName(), targetParameter.getName());
            }
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)(targetClass.getName() + " is conform to #" + sourceClass.getName()));
        }
    }
}

