/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.maven.plugins.toolbox;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import fr.ird.observe.maven.plugins.toolbox.ValidatorCacheRequest;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.maven.plugin.logging.Log;
import org.nuiton.validator.NuitonValidatorScope;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class ValidatorsCache {
    private static final ValidatorsCache instance = new ValidatorsCache();
    private final Multimap<String, ValidatorInfo> validators = ArrayListMultimap.create();

    public static ValidatorsCache get() {
        return instance;
    }

    public Collection<ValidatorInfo> getValidators(ValidatorCacheRequest request) throws IOException {
        Log log = request.getLog();
        boolean verbose = request.isVerbose();
        Path sourceRootPath = request.getSourceRootPath();
        String key = sourceRootPath.toFile().getAbsolutePath();
        if (!this.validators.containsKey((Object)key)) {
            log.info((CharSequence)("Loading validators from " + sourceRootPath));
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(request.getUrlClassLoader());
                PathSimpleFileVisitorResult result = new PathSimpleFileVisitor(log, sourceRootPath, verbose).walk();
                NuitonValidatorScope[] scopes = result.getEffectiveScopes();
                for (ValidatorDescriptor descritptor : result.descritptors) {
                    String typeName = descritptor.getTypeName();
                    String context = descritptor.getContext();
                    Class<?> type = Class.forName(typeName);
                    SimpleBeanValidator validator = SimpleBeanValidator.newValidator(type, (String)context, (NuitonValidatorScope[])scopes);
                    for (NuitonValidatorScope scope : validator.getEffectiveScopes()) {
                        Set effectiveFields = validator.getEffectiveFields(scope);
                        ValidatorInfo validatorInfo = new ValidatorInfo(type, context, scope, effectiveFields);
                        this.validators.put((Object)key, (Object)validatorInfo);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        return this.validators.get((Object)key);
    }

    private static class PathSimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final Set<ValidatorDescriptor> descritptors = new LinkedHashSet<ValidatorDescriptor>();
        private final Set<String> scopes = new LinkedHashSet<String>();
        private final Log log;
        private final Path sourceRootPath;
        private final boolean verbose;
        private String packageName = "";

        PathSimpleFileVisitor(Log log, Path sourceRootPath, boolean verbose) {
            this.log = log;
            this.sourceRootPath = sourceRootPath;
            this.verbose = verbose;
            for (NuitonValidatorScope scope : NuitonValidatorScope.values()) {
                this.scopes.add(scope.name().toLowerCase());
            }
        }

        public PathSimpleFileVisitorResult walk() throws IOException {
            Files.walkFileTree(this.sourceRootPath, this);
            this.log.info((CharSequence)(this.descritptors.size() + " type(s) detected."));
            return new PathSimpleFileVisitorResult(this.descritptors);
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (!dir.equals(this.sourceRootPath)) {
                if (!this.packageName.isEmpty()) {
                    this.packageName = this.packageName + ".";
                }
                this.packageName = this.packageName + dir.toFile().getName();
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (!dir.equals(this.sourceRootPath)) {
                String name = dir.toFile().getName();
                this.packageName = this.packageName.substring(0, this.packageName.length() - name.length());
                if (this.packageName.endsWith(".")) {
                    this.packageName = this.packageName.substring(0, this.packageName.length() - 1);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String name = file.toFile().getName();
            if (name.endsWith("-validation.xml")) {
                String context;
                ValidatorDescriptor descritptor;
                boolean add;
                int i = name.indexOf(45);
                String typeName = this.packageName + "." + name.substring(0, i);
                String rest = name.substring(i);
                LinkedHashSet<String> contexts = new LinkedHashSet<String>();
                StringTokenizer tok = new StringTokenizer(rest, "-");
                NuitonValidatorScope scope = null;
                while (tok.hasMoreTokens()) {
                    String token = tok.nextToken();
                    if (this.scopes.contains(token)) {
                        scope = NuitonValidatorScope.valueOf((String)token.toUpperCase());
                        break;
                    }
                    contexts.add(token);
                }
                if ((add = this.descritptors.add(descritptor = new ValidatorDescriptor(typeName, context = String.join((CharSequence)"-", contexts), scope))) && this.verbose) {
                    this.log.info((CharSequence)("Register " + typeName));
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }

    private static class ValidatorDescriptor {
        private final String typeName;
        private final String context;
        private final NuitonValidatorScope scope;

        private ValidatorDescriptor(String typeName, String context, NuitonValidatorScope scope) {
            this.typeName = typeName;
            this.context = context;
            this.scope = scope;
        }

        public String getTypeName() {
            return this.typeName;
        }

        public String getContext() {
            return this.context;
        }

        public NuitonValidatorScope getScope() {
            return this.scope;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidatorDescriptor that = (ValidatorDescriptor)o;
            return Objects.equals(this.getTypeName(), that.getTypeName()) && Objects.equals(this.getContext(), that.getContext()) && this.getScope() == that.getScope();
        }

        public int hashCode() {
            return Objects.hash(this.getTypeName(), this.getContext(), this.getScope());
        }
    }

    private static class PathSimpleFileVisitorResult {
        private final Set<ValidatorDescriptor> descritptors;

        private PathSimpleFileVisitorResult(Set<ValidatorDescriptor> descritptors) {
            this.descritptors = descritptors;
        }

        public NuitonValidatorScope[] getEffectiveScopes() {
            EnumSet<NuitonValidatorScope> result = EnumSet.noneOf(NuitonValidatorScope.class);
            result.addAll(this.descritptors.stream().map(ValidatorDescriptor::getScope).collect(Collectors.toList()));
            return result.toArray(new NuitonValidatorScope[result.size()]);
        }
    }

    public static class ValidatorInfo {
        private final Class<?> type;
        private final String context;
        private final NuitonValidatorScope scope;
        private final Set<String> fields;

        ValidatorInfo(Class<?> type, String context, NuitonValidatorScope scope, Set<String> fields) {
            this.type = type;
            this.context = context;
            this.scope = scope;
            this.fields = fields;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getContext() {
            return this.context;
        }

        public NuitonValidatorScope getScope() {
            return this.scope;
        }

        public Set<String> getFields() {
            return this.fields;
        }
    }
}

