/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: MyAccount.java 119 2011-02-25 17:16:46Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.6/refcomp-client/src/main/java/fr/inra/refcomp/client/user/MyAccount.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.user;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.users.UserForm;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.User;

/**
 * User: couteau
 * Date: 13/01/11
 */
public class MyAccount extends Composite {

    private static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("MyAccount.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, MyAccount> {}

    @UiField
    Form form;

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    public MyAccount() {
        initWidget(binder.createAndBindUi(this));

        UserForm userForm = new UserForm(UserForm.USER_CONTEXT);

        form.setContentPanel(userForm);
        form.setFormStyleName("moncompte");

        service.getLoggedInUser(new RefcompCallBack<User>() {
            @Override
            public void onSuccess(User result) {
                form.setContent(result, false);
                form.allowDeletion(false);
                UserForm userForm = (UserForm) form.getContentPanel();

                userForm.setMyAccountMode();
            }
        });
    }
}
