/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: CatiForm.java 239 2011-10-05 09:06:44Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.5.1/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/cati/CatiForm.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.cati;

import com.google.gwt.core.client.GWT;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.TextBox;
import fr.inra.refcomp.client.constants.FormContent;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.constants.RefcompMessages;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Cati;
import fr.inra.refcomp.services.InvalidEntityException;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 29 nov. 2010
 */
public class CatiForm extends Composite implements FormContent {

    private final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("CatiForm.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, CatiForm> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    private RefcompMessages messages = GWT.create(RefcompMessages.class);

    @UiField
    TextBox nameBox;

    @UiField
    TextBox fullNameBox;

    @UiField
    HTMLPanel errorPanel;

    @UiField
    Label errorLabel;

    Cati bean;

    public CatiForm() {
        initWidget(binder.createAndBindUi(this));
        nameBox.setEnabled(false);
        fullNameBox.setEnabled(false);
    }

    @Override
    public void setContent(BusinessEntity bean) {

        if ((bean != null) && (bean instanceof Cati)) {
            this.bean = (Cati) bean;
            nameBox.setText(this.bean.getName());
            nameBox.setEnabled(true);
            fullNameBox.setText(this.bean.getFullName());
            fullNameBox.setEnabled(true);
            errorPanel.setVisible(false);
        }
    }

    @Override
    public void clearContent() {
        bean = null;
        nameBox.setText("");
        nameBox.setEnabled(false);
        fullNameBox.setText("");
        fullNameBox.setEnabled(false);
        errorPanel.setVisible(false);
    }

    @Override
    public BusinessEntity getContent() {
        if (bean != null) {
            bean.setName(nameBox.getText());
            bean.setFullName(fullNameBox.getText());
        }
        return bean;
    }

    @Override
    public void saveContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {

            errorPanel.setVisible(false);

            service.saveCati((Cati) getContent(),
                    new RefcompCallBack<Cati>() {
                        @Override
                        public void onSuccess(Cati result) {
                            setContent(result);
                            AdminCati.refresh();
                        }

                        @Override
                        public void onFailure(Throwable caught) {
                            if (caught instanceof InvalidEntityException) {
                                History.newItem("error");
                                errorPanel.setVisible(true);
                                errorLabel.setText(caught.getMessage());
                            } else {
                                Window.alert(messages.exception());
                            }
                        }
                    });
        }
    }

    @Override
    public void cancelContent(Boolean creation) {

        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            clearContent();
        }

    }

    @Override
    public void deleteContent() {
        Boolean validate = Window.confirm(messages.sure());

        if (validate) {
            service.deleteCati((Cati) getContent(),
                    new RefcompCallBack<Void>() {
                        @Override
                        public void onSuccess(Void result) {
                            clearContent();
                            AdminCati.refresh();
                        }
                    });
        }
    }
}
