/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: Form.java 119 2011-02-25 17:16:46Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-client/src/main/java/fr/inra/refcomp/client/constants/Form.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.constants;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.FormPanel;
import com.google.gwt.user.client.ui.Panel;
import org.nuiton.wikitty.entities.BusinessEntity;

/**
 * User: couteau
 * Date: 26 nov. 2010
 */
public class Form extends Composite {

    @UiTemplate("Form.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, Form> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    protected FormPanel contentPanel;

    @UiField
    protected FlowPanel buttonsPanel;

    @UiField
    protected Button deleteButton;

    protected FormContent content;

    protected Boolean creation;

    public Form() {
        initWidget(binder.createAndBindUi(this));
    }

    public Form(FormContent contentPanel){
        this();
        setContentPanel(contentPanel);
    }

    public void setContent(BusinessEntity bean, boolean creation){
        this.creation = creation;
        content.setContent(bean);
    }

    public void clearContent(){
        content.clearContent();
    }

    public void setContentPanel(FormContent contentPanel){
        this.contentPanel.clear();
        content = contentPanel;
        this.contentPanel.add(content);
    }

    public FormContent getContentPanel(){
        return content;
    }

    public void setFormStyleName(String styleName){
        contentPanel.setStyleName(styleName);
        buttonsPanel.setStyleName(styleName);
    }

    public void allowDeletion(boolean allow) {
        deleteButton.setVisible(false);
    }

    @UiHandler("okButton")
    void doClickOk(ClickEvent event) {
        content.saveContent(creation);
    }

    @UiHandler("cancelButton")
    void doClickCancel(ClickEvent event) {
        content.cancelContent(creation);
    }

    @UiHandler("deleteButton")
    void doClickDelete(ClickEvent event) {
        content.deleteContent();
    }

}
