/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AgentUtil.java 79 2011-01-27 17:45:56Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.2/refcomp-client/src/main/java/fr/inra/refcomp/client/agent/AgentUtil.java $
 * %%
 * Copyright (C) 2010 - 2011 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.agent;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.RootPanel;
import fr.inra.refcomp.client.constants.Unauthorized;
import fr.inra.refcomp.client.services.StorageService;
import fr.inra.refcomp.client.services.StorageServiceAsync;

/**
 * User: couteau
 * Date: 29/12/10
 */
public class AgentUtil {
    private static final StorageServiceAsync service = GWT.create(StorageService.class);

    public static void checkAgent() {
        service.isAgent(new AsyncCallback<Boolean>() {
            @Override
            public void onFailure(Throwable throwable) {
                //don't know what to do
            }

            @Override
            public void onSuccess(Boolean isAgent) {
                if (!isAgent) {
                    RootPanel content = RootPanel.get("content");
                    content.clear();
                    content.add(new Unauthorized());
                }
            }
        });
    }
}
