/*
 * #%L
 * Refcomp :: GWT client
 * 
 * $Id: AdminFrequencies.java 114 2011-02-16 17:17:55Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.0/refcomp-client/src/main/java/fr/inra/refcomp/client/admin/frequencies/AdminFrequencies.java $
 * %%
 * Copyright (C) 2010 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.client.admin.frequencies;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.uibinder.client.UiTemplate;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import fr.inra.refcomp.client.admin.AdminUtil;
import fr.inra.refcomp.client.constants.Form;
import fr.inra.refcomp.client.constants.RefcompCallBack;
import fr.inra.refcomp.client.services.StorageService;
import java.util.List;
import fr.inra.refcomp.client.services.StorageServiceAsync;
import fr.inra.refcomp.entities.Frequency;

/**
 * User: couteau
 * Date: 26 nov. 2010
 */
public class AdminFrequencies extends Composite {

    protected static final StorageServiceAsync service = GWT
            .create(StorageService.class);

    @UiTemplate("AdminFrequencies.ui.xml")
    interface MyUiBinder extends UiBinder<Panel, AdminFrequencies> {
    }

    private static final MyUiBinder binder = GWT.create(MyUiBinder.class);

    @UiField
    static ListBox frequenciesList;

    @UiField
    Form form;

    @UiHandler("addButton")
    void doClickAdd(ClickEvent event) {
        service.createFrequency(new RefcompCallBack<Frequency>() {
            @Override
            public void onSuccess(Frequency result) {
                form.setContent(result, true);
            }
        });
    }

    public AdminFrequencies() {
        initWidget(binder.createAndBindUi(this));

        History.newItem("adminFrequencies");

        AdminUtil.checkAdmin();
        refresh();

        FrequenciesForm freqForm = new FrequenciesForm();

        form.setContentPanel(freqForm);

        frequenciesList.addChangeHandler(new ChangeHandler(){
            @Override
            public void onChange(ChangeEvent event){

                String beanId = frequenciesList.getValue(frequenciesList.getSelectedIndex());

                service.getFrequency(beanId, new RefcompCallBack<Frequency>() {
                    @Override
                    public void onSuccess(Frequency result) {
                        form.setContent(result, false);
                    }
                });

            }
        });
    }

    public static void refresh(){
        service.getFrequencies(new RefcompCallBack<List<Frequency>>() {
            @Override
            public void onSuccess(List<Frequency> result) {
                frequenciesList.clear();
                for (Frequency frequency : result) {
                    if (frequency != null){
                        frequenciesList.addItem(frequency.getName(),
                            frequency.getWikittyId());
                    }
                }
            }
        });
    }
}
