/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.caracteristics;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fr.ifremer.tutti.persistence.entities.CaracteristicMap;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapCellComponent;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapColumnRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorRowModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorTableModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUI;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicMapEditorUIModel;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueEditor;
import fr.ifremer.tutti.ui.swing.util.caracteristics.CaracteristicValueRenderer;
import fr.ifremer.tutti.ui.swing.util.table.AbstractTuttiTableUIHandler;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnModelExt;
import org.nuiton.jaxx.application.swing.ApplicationUI;

public class CaracteristicMapEditorUIHandler
extends AbstractTuttiTableUIHandler<CaracteristicMapEditorRowModel, CaracteristicMapEditorUIModel, CaracteristicMapEditorUI> {
    private static final Log log = LogFactory.getLog(CaracteristicMapEditorUIHandler.class);
    protected CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor;

    public CaracteristicMapEditorUIHandler() {
        super("value");
    }

    public CaracteristicMapEditorTableModel getTableModel() {
        return (CaracteristicMapEditorTableModel)((Object)this.getTable().getModel());
    }

    @Override
    public JXTable getTable() {
        return ((CaracteristicMapEditorUI)this.ui).getCaracteristicMapEditorTable();
    }

    @Override
    protected boolean isRowValid(CaracteristicMapEditorRowModel row) {
        return row.getKey() != null && row.getValue() != null;
    }

    @Override
    protected void onRowModified(int rowIndex, CaracteristicMapEditorRowModel row, String propertyName, Object oldValue, Object newValue) {
        this.recomputeRowValidState(row);
        super.onRowModified(rowIndex, row, propertyName, oldValue, newValue);
        this.saveSelectedRowIfNeeded();
    }

    @Override
    protected void saveSelectedRowIfRequired(TuttiBeanMonitor<CaracteristicMapEditorRowModel> rowMonitor, CaracteristicMapEditorRowModel row) {
        if (row.isValid() && rowMonitor.wasModified()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Row " + (Object)((Object)row) + " was modified, will save it"));
            }
            this.saveRow(row);
        }
    }

    protected void beforeOpenPopup(int rowIndex, int columnIndex) {
        super.beforeOpenPopup(rowIndex, columnIndex);
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).setRemoveCaracteristicEnabled(rowIndex >= 0);
    }

    public void beforeInit(CaracteristicMapEditorUI ui) {
        super.beforeInit((ApplicationUI)ui);
        CaracteristicMapEditorUIModel model = new CaracteristicMapEditorUIModel();
        ui.setContextValue(model);
    }

    public void afterInit(CaracteristicMapEditorUI ui) {
        this.initUI(ui);
        this.initBeanFilterableComboBox(this.getKeyCombo(), new ArrayList(), null);
        ((CaracteristicMapEditorUIModel)((Object)this.getModel())).setAllAvailableCaracteristics(new ArrayList<Caracteristic>(this.getDataContext().getCaracteristicWithProtected()));
        JXTable table = this.getTable();
        DefaultTableColumnModelExt columnModel = new DefaultTableColumnModelExt();
        this.addColumnToModel((TableColumnModel)columnModel, null, this.newTableCellRender(Caracteristic.class, "withUnit"), CaracteristicMapEditorTableModel.KEY);
        this.addColumnToModel((TableColumnModel)columnModel, new CaracteristicValueEditor(this.getContext()), new CaracteristicValueRenderer(this.getContext()), CaracteristicMapEditorTableModel.VALUE);
        CaracteristicMapEditorTableModel tableModel = new CaracteristicMapEditorTableModel((TableColumnModelExt)columnModel);
        table.setModel((TableModel)((Object)tableModel));
        table.setColumnModel((TableColumnModel)columnModel);
        this.initTable(table);
    }

    protected JComponent getComponentToFocus() {
        return ((CaracteristicMapEditorUI)this.getUI()).getNewRowKey();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.caracteristicMapCellEditor.closeEditor();
    }

    public SwingValidator<CaracteristicMapEditorUIModel> getValidator() {
        return null;
    }

    public CaracteristicMapCellComponent.CaracteristicMapCellEditor getCaracteristicMapCellEditor() {
        return this.caracteristicMapCellEditor;
    }

    public void editBatch(CaracteristicMapColumnRowModel caracteristicMapColumnRowModel, CaracteristicMapCellComponent.CaracteristicMapCellEditor caracteristicMapCellEditor, Set<Caracteristic> caracteristicsUsed) {
        this.caracteristicMapCellEditor = caracteristicMapCellEditor;
        CaracteristicMapEditorTableModel tableModel = this.getTableModel();
        CaracteristicMapEditorUIModel model = (CaracteristicMapEditorUIModel)((Object)this.getModel());
        CaracteristicMap caracteristicMap = caracteristicMapColumnRowModel.getCaracteristics();
        if (MapUtils.isEmpty((Map)caracteristicMap)) {
            caracteristicMap = new CaracteristicMap();
            caracteristicMap.putAll(Maps.asMap(caracteristicsUsed, (Function)Functions.constant((Object)null)));
        }
        model.setCaracteristicMap(caracteristicMap);
        ArrayList rows = Lists.newArrayList();
        ArrayList caracteristics = Lists.newArrayList((Iterable)caracteristicMap.keySet());
        List<Caracteristic> availableCaracteristics = model.getAvailableCaracteristics();
        for (Object key : caracteristics) {
            CaracteristicMapEditorRowModel newRow = tableModel.createNewRow();
            newRow.setKey((Caracteristic)key);
            newRow.setValue((Serializable)caracteristicMap.get(key));
            rows.add(newRow);
        }
        model.setRows(rows);
        caracteristics.add(caracteristicMapColumnRowModel.getLengthStepCaracteristic());
        ArrayList caracteristicList = Lists.newArrayList();
        for (Caracteristic caracteristic : availableCaracteristics) {
            if (caracteristics.contains(caracteristic)) continue;
            caracteristicList.add(caracteristic);
        }
        BeanFilterableComboBox<Caracteristic> keyCombo = this.getKeyCombo();
        keyCombo.setData((List)caracteristicList);
        keyCombo.getHandler().reset();
        model.setModify(false);
    }

    protected BeanFilterableComboBox<Caracteristic> getKeyCombo() {
        return ((CaracteristicMapEditorUI)this.ui).getNewRowKey();
    }

    protected void saveRow(CaracteristicMapEditorRowModel row) {
        if (row.isValid()) {
            CaracteristicMap caracteristics = ((CaracteristicMapEditorUIModel)((Object)this.getModel())).getCaracteristicMap();
            Preconditions.checkNotNull((Object)caracteristics);
            caracteristics.put(row.getKey(), row.getValue());
        }
    }
}

