/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.attachment.actions;

import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.ui.swing.util.actions.SimpleActionSupport;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentEditorUI;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItem;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentItemModel;
import fr.ifremer.tutti.ui.swing.util.attachment.AttachmentModelAware;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RemoveAttachmentAction
extends SimpleActionSupport<AttachmentItem> {
    private static final Log log = LogFactory.getLog(RemoveAttachmentAction.class);
    private static final long serialVersionUID = 1L;

    public RemoveAttachmentAction(AttachmentItem ui) {
        super(ui);
    }

    @Override
    protected void onActionPerformed(AttachmentItem ui) {
        AttachmentEditorUI upperUI = ui.getParentContainer(AttachmentEditorUI.class);
        AttachmentItemModel model = ui.getModel();
        boolean hackDialog = upperUI.isAlwaysOnTop();
        if (hackDialog) {
            upperUI.setAlwaysOnTop(false);
        }
        int answer = JOptionPane.showConfirmDialog(upperUI, I18n.t((String)"tutti.attachmentEditor.deleteAttachment.message", (Object[])new Object[]{model.getName()}), I18n.t((String)"tutti.attachmentEditor.deleteAttachment.title", (Object[])new Object[0]), 0);
        if (hackDialog) {
            upperUI.setAlwaysOnTop(true);
        }
        if (answer == 0) {
            AttachmentModelAware bean = upperUI.getBean();
            if (log.isInfoEnabled()) {
                log.info((Object)("Remove attachment: " + model.getName()));
            }
            if (!model.isCreate()) {
                ui.getHandler().getPersistenceService().deleteAttachment(model.getId());
            }
            bean.removeAttachment((Attachment)model.toEntity());
            upperUI.getAttachments().remove(ui);
            upperUI.pack();
        }
    }
}

