/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.actions;

import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.InvalidBatchModelException;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.WeightCleaningService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.edit.SpeciesBatchUI;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class CleanBatchWeightsAction
extends LongActionSupport<EditCatchesUIModel, EditCatchesUI, EditCatchesUIHandler> {
    private static final Log log = LogFactory.getLog(CleanBatchWeightsAction.class);
    protected final WeightCleaningService cleaningService = this.getContext().getWeightCleaningService();
    protected int nbErrors;

    public CleanBatchWeightsAction(EditCatchesUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            FishingOperation fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
            Multimap errors = this.cleaningService.checkFishingOperation(fishingOperation.getIdAsInt());
            this.nbErrors = errors.size();
            if (this.nbErrors == 0) {
                this.sendMessage(I18n.t((String)"tutti.editCatchBatch.action.cleanWeights.no.double.weight.detected", (Object[])new Object[0]));
                doAction = false;
            } else {
                String errorsStr = this.cleaningService.errorsToString(errors);
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCatchBatch.action.cleanWeights.double.weight.detected", (Object[])new Object[]{errorsStr}), I18n.t((String)"tutti.editCatchBatch.action.cleanWeights.help", (Object[])new Object[0]));
                int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCatchBatch.action.cleanWieghts.resume.title", (Object[])new Object[0]), 2, 3);
                doAction = answer == 0;
            }
        }
        return doAction;
    }

    @Override
    public void doAction() throws Exception {
        block5: {
            FishingOperation fishingOperation;
            block4: {
                EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
                fishingOperation = ((EditCatchesUIModel)this.getModel()).getFishingOperation();
                model.setLoadingData(true);
                this.cleaningService.cleanFishingOperation(fishingOperation.getIdAsInt());
                try {
                    this.getSpeciesBatchUI().getHandler().selectFishingOperation(fishingOperation);
                }
                catch (InvalidBatchModelException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"Invalid sample category model for species batches", (Throwable)e);
                }
            }
            try {
                this.getBenthosBatchUI().getHandler().selectFishingOperation(fishingOperation);
            }
            catch (InvalidBatchModelException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"Invalid sample category model for benthos batches", (Throwable)e);
            }
        }
    }

    public void postSuccessAction() {
        super.postSuccessAction();
        this.sendMessage(I18n.t((String)"tutti.editCatchBatch.action.cleanWeights.done", (Object[])new Object[]{this.nbErrors}));
    }

    private SpeciesBatchUI getBenthosBatchUI() {
        return ((EditCatchesUI)this.getUI()).getBenthosTabPanel().getEditBatchesUI();
    }

    private SpeciesBatchUI getSpeciesBatchUI() {
        return ((EditCatchesUI)this.getUI()).getSpeciesTabPanel().getEditBatchesUI();
    }
}

