/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.ArrayList;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.CompatiblePropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.xml.sax.SAXException;

class CompatiblePropToExprState
extends CompatiblePropertyState {
    private static final int DEFAULT_VALUE_PROP = "defaultValue".toLowerCase().hashCode();

    CompatiblePropToExprState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    @Override
    public void end() throws SAXException {
        CompatiblePropToExprState.handleDefaultValueList(this.handler.module, this.element, this.propDefn, this.nameValue, this.handler.versionNumber, this.text.toString());
    }

    private static String doCompatibility(int versionNumber, String value, DesignElement element, int propCode) {
        if (versionNumber < 3020400 && element instanceof ScalarParameter && DEFAULT_VALUE_PROP == propCode) {
            return StringUtil.trimQuotes(value);
        }
        return value;
    }

    public static void handleDefaultValueList(Module module, DesignElement element, PropertyDefn propDefn, int propCode, int versionNumber, String input) {
        String value = CompatiblePropToExprState.doCompatibility(versionNumber, input, element, propCode);
        int tmpType = propDefn.getTypeCode();
        Object newValue = null;
        if (tmpType == 20) {
            ArrayList<Expression> newList = new ArrayList<Expression>();
            newList.add(new Expression(value, "constant"));
            newValue = newList;
        } else {
            newValue = new Expression(value, "constant");
        }
        try {
            newValue = propDefn.getType().validateValue(module, element, propDefn, newValue);
        }
        catch (PropertyValueException propertyValueException) {}
        if (newValue == null) {
            return;
        }
        element.setProperty(propDefn, newValue);
    }
}

