/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.protocol;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRowBean;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicType;
import fr.ifremer.tutti.persistence.entities.protocol.MaturityCaracteristic;
import fr.ifremer.tutti.persistence.entities.protocol.MaturityCaracteristics;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.service.AbstractTuttiService;
import fr.ifremer.tutti.service.protocol.CaracteristicRow;
import fr.ifremer.tutti.service.protocol.CaracteristicRowModel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.csv.Export;
import org.nuiton.csv.ExportModel;
import org.nuiton.csv.Import;
import org.nuiton.csv.ImportModel;
import org.nuiton.csv.ImportRuntimeException;
import org.nuiton.csv.ext.CsvReaders;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ProtocolCaracteristicsImportExportService
extends AbstractTuttiService {
    private static final Log log = LogFactory.getLog(ProtocolCaracteristicsImportExportService.class);

    public void importProtocolCaracteristic(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap) throws IOException {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will import protocol caracteristic from file: " + file));
        }
        ArrayList<String> lengthClassesPmfmIds = new ArrayList<String>(protocol.getLengthClassesPmfmId());
        ArrayList<String> individualObservationPmfmId = new ArrayList<String>(protocol.getIndividualObservationPmfmId());
        LinkedHashMap<String, MaturityCaracteristic> maturityCaracteristics = new LinkedHashMap<String, MaturityCaracteristic>();
        if (!protocol.isMaturityCaracteristicsEmpty()) {
            maturityCaracteristics.putAll((Map<String, MaturityCaracteristic>)Maps.uniqueIndex((Iterable)protocol.getMaturityCaracteristics(), MaturityCaracteristic::getId));
        }
        LinkedHashMap<String, CaracteristicMappingRow> rowsByCaracteristicId = new LinkedHashMap<String, CaracteristicMappingRow>();
        if (!protocol.isCaracteristicMappingEmpty()) {
            rowsByCaracteristicId.putAll((Map<String, CaracteristicMappingRow>)Maps.uniqueIndex((Iterable)protocol.getCaracteristicMapping(), CaracteristicMappingRow::getPmfmId));
        }
        try (BufferedReader reader = Files.newReader((File)file, (Charset)StandardCharsets.UTF_8);){
            CaracteristicRowModel csvModel = CaracteristicRowModel.forImport(this.getCsvSeparator(), caracteristicMap);
            try (Import importer = Import.newImport((ImportModel)csvModel, (Reader)reader);){
                for (CaracteristicRow bean : importer) {
                    CaracteristicType caracteristicType = bean.getPmfmType();
                    Caracteristic caracteristic = bean.getPmfm();
                    String id = caracteristic.getId();
                    switch (caracteristicType) {
                        case INDIVIDUAL_OBSERVATION: {
                            individualObservationPmfmId.add(id);
                            break;
                        }
                        case LENGTH_STEP: {
                            lengthClassesPmfmIds.add(id);
                            break;
                        }
                        case MATURITY: {
                            MaturityCaracteristic maturityCaracteristic = (MaturityCaracteristic)maturityCaracteristics.get(id);
                            if (maturityCaracteristic != null) break;
                            maturityCaracteristic = MaturityCaracteristics.newMaturityCaracteristic();
                            maturityCaracteristic.setId(id);
                            maturityCaracteristic.setMatureStateIds(bean.getMatureStateIds());
                            maturityCaracteristics.put(id, maturityCaracteristic);
                            break;
                        }
                        case VESSEL_USE_FEATURE: 
                        case GEAR_USE_FEATURE: {
                            CaracteristicMappingRow row = (CaracteristicMappingRow)rowsByCaracteristicId.get(id);
                            if (row != null) break;
                            row = new CaracteristicMappingRowBean();
                            row.setPmfmId(id);
                            row.setTab(caracteristicType.name());
                            rowsByCaracteristicId.put(id, row);
                        }
                    }
                }
            }
        }
        catch (ImportRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ImportRuntimeException("Could not import protocol [" + protocol.getName() + "] caracteristic from file " + file, (Throwable)e);
        }
        protocol.setLengthClassesPmfmId(lengthClassesPmfmIds);
        protocol.setIndividualObservationPmfmId(individualObservationPmfmId);
        protocol.setMaturityCaracteristics(new ArrayList(maturityCaracteristics.values()));
        protocol.setCaracteristicMapping(new ArrayList(rowsByCaracteristicId.values()));
    }

    public void exportAllCaracteristic(File file, Map<String, Caracteristic> caracteristicMap) {
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristics to file: " + file));
        }
        PmfmIdToCaracteristicRowFunction function = new PmfmIdToCaracteristicRowFunction(caracteristicMap);
        List rows = caracteristicMap.keySet().stream().map(function).collect(Collectors.toList());
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            CaracteristicRowModel csvModel = CaracteristicRowModel.forExport(this.getCsvSeparator());
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ImportRuntimeException(I18n.t((String)"tutti.service.protocol.export.caracteristics.all.error", (Object[])new Object[]{file}), (Throwable)e);
        }
    }

    public void exportProtocolCaracteristic(File file, TuttiProtocol protocol, Map<String, Caracteristic> caracteristicMap) {
        CaracteristicRow row;
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export all caracteristics to file: " + file));
        }
        ArrayList<CaracteristicRow> rows = new ArrayList<CaracteristicRow>();
        PmfmIdToCaracteristicRowFunction function = new PmfmIdToCaracteristicRowFunction(caracteristicMap);
        if (!protocol.isLengthClassesPmfmIdEmpty()) {
            for (String pmfmId : protocol.getLengthClassesPmfmId()) {
                row = this.getCaracteristicRow(CaracteristicType.LENGTH_STEP, pmfmId, function);
                rows.add(row);
            }
        }
        if (!protocol.isIndividualObservationPmfmIdEmpty()) {
            for (String pmfmId : protocol.getIndividualObservationPmfmId()) {
                row = this.getCaracteristicRow(CaracteristicType.INDIVIDUAL_OBSERVATION, pmfmId, function);
                rows.add(row);
            }
        }
        if (!protocol.isMaturityCaracteristicsEmpty()) {
            for (MaturityCaracteristic maturityCaracteristic : protocol.getMaturityCaracteristics()) {
                row = this.getCaracteristicRow(CaracteristicType.MATURITY, maturityCaracteristic.getId(), function);
                if (!maturityCaracteristic.isMatureStateIdsEmpty()) {
                    row.setMatureStateIds(new LinkedHashSet<String>(maturityCaracteristic.getMatureStateIds()));
                }
                rows.add(row);
            }
        }
        if (!protocol.isCaracteristicMappingEmpty()) {
            for (CaracteristicMappingRow mappingRow : protocol.getCaracteristicMapping()) {
                row = this.getCaracteristicRow(CaracteristicType.valueOf((String)mappingRow.getTab()), mappingRow.getPmfmId(), function);
                rows.add(row);
            }
        }
        try (BufferedWriter writer = Files.newWriter((File)file, (Charset)StandardCharsets.UTF_8);){
            CaracteristicRowModel csvModel = CaracteristicRowModel.forExport(this.getCsvSeparator());
            Export export = Export.newExport((ExportModel)csvModel, rows);
            export.write((Writer)writer);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.protocol.export.caracteristics.protocol.error", (Object[])new Object[]{protocol.getName(), file}), (Throwable)e);
        }
    }

    public List<String> loadProtocolCaracteristicsImportColumns(File columnsFile) throws IOException {
        String[] headers = CsvReaders.getHeader((File)columnsFile, (char)';');
        ArrayList<String> result = new ArrayList<String>(headers.length);
        for (String header : headers) {
            if (header.startsWith("\"") && header.endsWith("\"") || header.startsWith("'") && header.endsWith("'")) {
                header = header.substring(1, header.length() - 1);
            }
            result.add(header);
        }
        Collections.sort(result);
        return result;
    }

    private CaracteristicRow getCaracteristicRow(CaracteristicType caracteristicType, String id, PmfmIdToCaracteristicRowFunction function) {
        CaracteristicRow row = function.apply(id);
        row.setPmfmType(caracteristicType);
        return row;
    }

    private char getCsvSeparator() {
        return this.context.getConfig().getCsvSeparator();
    }

    private static class PmfmIdToCaracteristicRowFunction
    implements Function<String, CaracteristicRow> {
        private final Map<String, Caracteristic> caracteristicMap;

        public PmfmIdToCaracteristicRowFunction(Map<String, Caracteristic> caracteristicMap) {
            this.caracteristicMap = caracteristicMap;
        }

        @Override
        public CaracteristicRow apply(String input) {
            Caracteristic caracteristic = this.caracteristicMap.get(input);
            Preconditions.checkNotNull((Object)caracteristic, (Object)("Could not find a caracteristic with id: " + input));
            CaracteristicRow result = new CaracteristicRow();
            result.setPmfm(caracteristic);
            return result;
        }
    }
}

