/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.export.toconfirmreport;

import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.service.PersistenceService;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ToConfirmReportFishingOperationData {
    private static final Log log = LogFactory.getLog(ToConfirmReportFishingOperationData.class);
    final FishingOperation fishingOperation;
    final CatchBatch catchBatch;
    final List<SpeciesBatch> speciesBatchToConfirm;
    final List<SpeciesBatch> benthosBatchToConfirm;

    public static ToConfirmReportFishingOperationData create(PersistenceService persistenceService, Integer fishingOperationId) {
        ToConfirmReportFishingOperationData result;
        boolean withCatchBatch = persistenceService.isFishingOperationWithCatchBatch(fishingOperationId);
        if (!withCatchBatch) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skip fishing operation " + fishingOperationId + " since no catchBatch associated."));
            }
            result = null;
        } else {
            FishingOperation fishingOperation = persistenceService.getFishingOperation(fishingOperationId);
            CatchBatch catchBatch = persistenceService.getCatchBatchFromFishingOperation(fishingOperationId);
            List<SpeciesBatch> speciesBatchToConfirm = persistenceService.getAllSpeciesBatchToConfirm(fishingOperationId);
            List<SpeciesBatch> benthosBatchToConfirm = persistenceService.getAllBenthosBatchToConfirm(fishingOperationId);
            if (CollectionUtils.isEmpty(speciesBatchToConfirm) && CollectionUtils.isEmpty(benthosBatchToConfirm)) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("No species nor benthos to confirm for fishing operation: " + fishingOperationId));
                }
                result = null;
            } else {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Found some species or benthos to confirm for fishing operation: " + fishingOperationId));
                }
                result = new ToConfirmReportFishingOperationData(fishingOperation, catchBatch, speciesBatchToConfirm, benthosBatchToConfirm);
            }
        }
        return result;
    }

    public FishingOperation getFishingOperation() {
        return this.fishingOperation;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public List<SpeciesBatch> getSpeciesBatchToConfirm() {
        return this.speciesBatchToConfirm;
    }

    public boolean isWithSpeciesBatchToConfirm() {
        return CollectionUtils.isNotEmpty(this.speciesBatchToConfirm);
    }

    public List<SpeciesBatch> getBenthosBatchToConfirm() {
        return this.benthosBatchToConfirm;
    }

    public boolean isWithBenthosBatchToConfirm() {
        return CollectionUtils.isNotEmpty(this.benthosBatchToConfirm);
    }

    private ToConfirmReportFishingOperationData(FishingOperation fishingOperation, CatchBatch catchBatch, List<SpeciesBatch> speciesBatchToConfirm, List<SpeciesBatch> benthosBatchToConfirm) {
        this.fishingOperation = fishingOperation;
        this.catchBatch = catchBatch;
        this.speciesBatchToConfirm = speciesBatchToConfirm;
        this.benthosBatchToConfirm = benthosBatchToConfirm;
    }
}

