/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.feed;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.feed.event.IchtyometerFeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.event.IchtyometerFeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderMeasureRecord;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderRecordFactory;
import fr.ifremer.tutti.ichtyometer.feed.record.IchtyometerFeedReaderRecordSupport;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.StreamConnection;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IchtyometerFeedReader
implements Closeable {
    private static final Log log = LogFactory.getLog(IchtyometerFeedReader.class);
    protected IchtyometerClient client;
    protected ReadingRunnable readingRunnable;
    protected final EventListenerList listenerList = new EventListenerList();
    protected final IchtyometerFeedReaderRecordFactory recordFactory = new IchtyometerFeedReaderRecordFactory();

    public void start(IchtyometerClient client) throws IOException {
        Preconditions.checkNotNull((Object)client, (Object)"client can not be null");
        Preconditions.checkState((boolean)client.isOpen(), (Object)"client must be opened");
        this.client = client;
        StreamConnection connection = client.openConnection();
        DataInputStream dataInputStream = connection.openDataInputStream();
        this.readingRunnable = new ReadingRunnable(dataInputStream);
        new Thread(this.readingRunnable).start();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ready to read remote device...");
        }
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull((Object)this.client, (Object)"client can not be null");
        Preconditions.checkState((boolean)this.client.isOpen(), (Object)"client must be opened");
        try {
            this.readingRunnable.stop();
        }
        finally {
            Closeables.close((Closeable)this.client, (boolean)true);
        }
    }

    public String getClientName() {
        return this.client.getName();
    }

    public void addFeedModeReaderListener(IchtyometerFeedReaderListener listener) {
        this.listenerList.add(IchtyometerFeedReaderListener.class, listener);
    }

    public void removeFeedModeReaderListener(IchtyometerFeedReaderListener listener) {
        this.listenerList.remove(IchtyometerFeedReaderListener.class, listener);
    }

    public void removeAllFeedModeReaderListeners() {
        for (IchtyometerFeedReaderListener listener : (IchtyometerFeedReaderListener[])this.listenerList.getListeners(IchtyometerFeedReaderListener.class)) {
            this.listenerList.remove(IchtyometerFeedReaderListener.class, listener);
        }
    }

    protected class ReadingRunnable
    implements Runnable {
        protected final DataInputStream dataInputStream;
        protected boolean stop;

        protected ReadingRunnable(DataInputStream dataInputStream) {
            this.dataInputStream = dataInputStream;
        }

        protected void stop() {
            this.stop = true;
        }

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reader thread start... " + this));
            }
            while (!this.stop) {
                try {
                    IchtyometerFeedReaderRecordSupport readerRecord = this.readRecord(this.dataInputStream);
                    if (this.stop || readerRecord == null || !(readerRecord instanceof IchtyometerFeedReaderMeasureRecord)) continue;
                    IchtyometerFeedReaderEvent e = new IchtyometerFeedReaderEvent(IchtyometerFeedReader.this, (IchtyometerFeedReaderMeasureRecord)readerRecord);
                    for (IchtyometerFeedReaderListener listener : (IchtyometerFeedReaderListener[])IchtyometerFeedReader.this.listenerList.getListeners(IchtyometerFeedReaderListener.class)) {
                        listener.recordRead(e);
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Could not read record", (Throwable)e);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reader thread stop..." + this));
            }
        }

        protected IchtyometerFeedReaderRecordSupport readRecord(DataInputStream dataInputStream) throws IOException {
            String result = "";
            boolean complete = false;
            while (!complete && !this.stop) {
                while (dataInputStream.available() > 0 && !complete && !this.stop) {
                    int c = dataInputStream.read();
                    result = result + (char)c;
                    if ('#' != (char)c) continue;
                    complete = true;
                }
            }
            IchtyometerFeedReaderRecordSupport readerRecord = null;
            if (!this.stop) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("New raw record: " + result));
                }
                readerRecord = IchtyometerFeedReader.this.recordFactory.newRecord(result);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New feed record: " + readerRecord));
                }
            }
            return readerRecord;
        }
    }
}

