/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.referential.actions;

import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.referential.ReferentialImportResult;
import fr.ifremer.tutti.service.referential.ReferentialTemporarySpeciesService;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUI;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIHandler;
import fr.ifremer.tutti.ui.swing.content.referential.ManageTemporaryReferentialUIModel;
import fr.ifremer.tutti.ui.swing.content.referential.actions.ImportTemporaryActionSupport;
import java.io.File;
import org.nuiton.i18n.I18n;

public class ImportTemporarySpeciesAction
extends ImportTemporaryActionSupport<Species> {
    public ImportTemporarySpeciesAction(ManageTemporaryReferentialUIHandler handler) {
        super(handler);
    }

    @Override
    protected File chooseImportFile() {
        return this.chooseFile(I18n.t((String)"tutti.manageTemporaryReferential.title.choose.importTemporarySpeciesFile", (Object[])new Object[0]), I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
    }

    @Override
    protected ReferentialImportResult<Species> doImport(File file) {
        ReferentialTemporarySpeciesService service = this.getContext().getReferentialTemporarySpeciesService();
        return service.importTemporarySpecies(file);
    }

    @Override
    protected void postSuccessAction(File file, ReferentialImportResult<Species> result) {
        int nbRef = ((ManageTemporaryReferentialUIModel)this.getModel()).getNbTemporarySpecies();
        ((ManageTemporaryReferentialUIModel)this.getModel()).setNbTemporarySpecies(nbRef + result.getNbRefAdded() - result.getNbRefDeleted());
        this.getDataContext().resetSpecies();
        this.reloadFishingOperation();
        ((ManageTemporaryReferentialUIHandler)this.getHandler()).resetComboBoxAction(((ManageTemporaryReferentialUI)this.getUI()).getSpeciesActionComboBox());
        String title = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.dialog.title", (Object[])new Object[0]);
        String message = I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.dialog.message", (Object[])new Object[]{result.getNbRefAdded(), result.getNbRefUpdated(), result.getNbRefDeleted()});
        this.displayInfoMessage(title, message);
        this.sendMessage(I18n.t((String)"tutti.manageTemporaryReferential.action.chooseReferentialSpeciesFile.import.success", (Object[])new Object[]{file}));
    }
}

