/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util.actions;

import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiDataContext;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.MainUI;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUI;
import fr.ifremer.tutti.ui.swing.util.species.SelectSpeciesUIModel;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;
import org.nuiton.util.StringUtil;

public abstract class LongActionSupport<M extends AbstractBean, UI extends TuttiUI<M, ?>, H extends AbstractTuttiUIHandler<M, UI>>
extends AbstractApplicationAction<M, UI, H> {
    public abstract void doAction() throws Exception;

    protected LongActionSupport(H handler, boolean hideBody) {
        super(handler, hideBody);
    }

    public TuttiUIContext getContext() {
        return ((AbstractTuttiUIHandler)this.handler).getContext();
    }

    public void setProgressionModel(ProgressionModel progressionModel) {
        super.setProgressionModel((ApplicationProgressionModel)progressionModel);
    }

    protected ProgressionModel getProgressionModel() {
        return (ProgressionModel)this.getContext().getActionUI().getModel().getProgressionModel();
    }

    public TuttiDataContext getDataContext() {
        return this.getContext().getDataContext();
    }

    protected TuttiConfiguration getConfig() {
        return this.getContext().getConfig();
    }

    protected void sendMessage(String message) {
        this.getContext().showInformationMessage(message);
    }

    protected void createProgressionModelIfRequired(int total) {
        ProgressionModel progressionModel = this.getProgressionModel();
        if (progressionModel == null) {
            progressionModel = new ProgressionModel();
            progressionModel.setMessage("");
            progressionModel.setCurrent(0);
            this.setProgressionModel(progressionModel);
            progressionModel.setTotal(total);
        } else {
            progressionModel.adaptTotal(total);
        }
    }

    protected Species openAddSpeciesDialog(String title, List<Species> species) {
        return this.openAddSpeciesDialog(title, species, null);
    }

    protected Species openAddSpeciesDialog(String title, List<Species> species, List<Species> filteredSpecies) {
        SelectSpeciesUI dialogContent = new SelectSpeciesUI(true, (TuttiUI)this.getUI());
        SelectSpeciesUIModel model = dialogContent.getModel();
        model.setSelectedSpecies(null);
        model.setSpecies(species);
        model.setFilteredSpecies(filteredSpecies);
        model.setShowAllSpecies(CollectionUtils.isEmpty(filteredSpecies));
        ((AbstractTuttiUIHandler)this.getHandler()).openDialog(dialogContent, title, new Dimension(400, 130));
        return model.getSelectedSpecies();
    }

    protected boolean askAdminPassword(String askMessage, String askMessageTitle, String errorMessage, String errorMessageTitle) {
        String answer;
        boolean result;
        MainUI container = this.getContext().getMainUI();
        do {
            if ((answer = JOptionPane.showInputDialog(container, askMessage, askMessageTitle, 2)) != null) {
                String correctAnswer;
                String cryptedAnswer = StringUtil.encodeMD5((String)answer);
                result = StringUtils.equals((CharSequence)cryptedAnswer, (CharSequence)(correctAnswer = this.getConfig().getAdminPassword()));
                if (result) continue;
                JOptionPane.showMessageDialog(container, errorMessage, errorMessageTitle, 0);
                continue;
            }
            result = false;
        } while (!result && answer != null);
        return result;
    }
}

