/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.util;

import com.google.common.base.Optional;
import fr.ifremer.tutti.util.BeepFrequency;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SoundUtil {
    private static final Log log = LogFactory.getLog(SoundUtil.class);
    public static String SOUNDS_DIRECTORY = "/sounds";
    public static float SAMPLE_RATE = 8000.0f;

    public static void beep(BeepFrequency beepFrequency) {
        SoundUtil.beep(beepFrequency, 1);
    }

    public static void beep(BeepFrequency beepFrequency, int number) {
        block3: {
            try {
                for (int i = 0; i < number; ++i) {
                    SoundUtil.tone(beepFrequency.getFrequency(), 500, 1.0);
                }
            }
            catch (LineUnavailableException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Error while playing a beep", (Throwable)e);
            }
        }
    }

    public static void tone(int hz, int msecs, double vol) throws LineUnavailableException {
        byte[] buf = new byte[1];
        AudioFormat af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        try (SourceDataLine sdl = AudioSystem.getSourceDataLine(af);){
            sdl.open(af);
            sdl.start();
            int end = msecs * 8;
            for (int i = 0; i < end; ++i) {
                double angle = (double)((float)i / (SAMPLE_RATE / (float)hz)) * 2.0 * Math.PI;
                buf[0] = (byte)(Math.sin(angle) * 127.0 * vol);
                sdl.write(buf, 0, 1);
            }
            sdl.drain();
            sdl.stop();
        }
    }

    public static void readNumber(double number, Optional<String> unit) {
        block30: {
            try {
                int thousands = (int)(number / 1000.0);
                int hundreds = (int)(number % 1000.0) / 100;
                int tensAndUnits = (int)number % 100;
                int decimal = (int)(number * 10.0) % 10;
                if (log.isDebugEnabled()) {
                    log.debug((Object)(thousands + " " + hundreds + " " + tensAndUnits + " " + decimal));
                }
                ArrayList<AudioInputStream> audioInputStreams = new ArrayList<AudioInputStream>();
                SoundUtil.addSound(audioInputStreams, thousands, 1000);
                SoundUtil.addSound(audioInputStreams, hundreds, 100);
                if (tensAndUnits != 0 || thousands == 0 && hundreds == 0) {
                    SoundUtil.addSound(audioInputStreams, tensAndUnits);
                }
                if (decimal > 0) {
                    SoundUtil.addSound(audioInputStreams, ",");
                    SoundUtil.addSound(audioInputStreams, decimal);
                }
                if (unit.isPresent()) {
                    SoundUtil.addSound(audioInputStreams, (String)unit.get());
                }
                if (audioInputStreams.isEmpty()) break block30;
                AudioFormat format = ((AudioInputStream)audioInputStreams.get(0)).getFormat();
                DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
                try (SourceDataLine audioLine = (SourceDataLine)AudioSystem.getLine(info);){
                    audioLine.open(format);
                    audioLine.start();
                    byte[] bytesBuffer = new byte[4096];
                    while (!audioInputStreams.isEmpty()) {
                        AudioInputStream audioInputStream = (AudioInputStream)audioInputStreams.remove(0);
                        Throwable throwable = null;
                        try {
                            int bytesRead;
                            while ((bytesRead = audioInputStream.read(bytesBuffer)) != -1) {
                                audioLine.write(bytesBuffer, 0, bytesRead);
                            }
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (audioInputStream == null) continue;
                            if (throwable != null) {
                                try {
                                    audioInputStream.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                                continue;
                            }
                            audioInputStream.close();
                        }
                    }
                    audioLine.drain();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block30;
                log.error((Object)("Error while reading " + number + " " + unit), (Throwable)e);
            }
        }
    }

    protected static long addSound(List<AudioInputStream> inputStreams, int number) throws IOException, UnsupportedAudioFileException {
        return SoundUtil.addSound(inputStreams, number, 1);
    }

    protected static long addSound(List<AudioInputStream> inputStreams, int number, int suffix) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioInputStream;
        long length = 0L;
        if (number > 1 || suffix == 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("-> add " + number + ".wav"));
            }
            audioInputStream = AudioSystem.getAudioInputStream(SoundUtil.class.getResource(SOUNDS_DIRECTORY + "/" + number + ".wav"));
            inputStreams.add(audioInputStream);
            length += audioInputStream.getFrameLength();
        }
        if (number >= 1 && suffix > 1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("-> add " + suffix + ".wav"));
            }
            audioInputStream = AudioSystem.getAudioInputStream(SoundUtil.class.getResource(SOUNDS_DIRECTORY + "/" + suffix + ".wav"));
            inputStreams.add(audioInputStream);
            length += audioInputStream.getFrameLength();
        }
        return length;
    }

    protected static long addSound(List<AudioInputStream> inputStreams, String name) throws IOException, UnsupportedAudioFileException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("add " + name + ".wav"));
        }
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(SoundUtil.class.getResource(SOUNDS_DIRECTORY + "/" + name + ".wav"));
        inputStreams.add(audioInputStream);
        return audioInputStream.getFrameLength();
    }
}

