/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyLogsTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class ApplySpeciesFrequencyRafaleAction {
    private static final Log log = LogFactory.getLog(ApplySpeciesFrequencyRafaleAction.class);
    private final SpeciesFrequencyUI ui;

    public ApplySpeciesFrequencyRafaleAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
    }

    public void applyRafaleStep(Float step, boolean fromIchtyometer) {
        int rowIndex;
        float aroundLengthStep;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will apply rafale step: " + step));
        }
        SpeciesFrequencyUIModel model = this.ui.getModel();
        SpeciesFrequencyUIHandler handler = this.ui.getHandler();
        SpeciesFrequencyTableModel tableModel = handler.getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = model.getRowCache();
        SpeciesFrequencyRowModel row = rowsByStep.get(Float.valueOf(aroundLengthStep = model.getLengthStep(step.floatValue())));
        if (row != null) {
            Integer number = row.getNumber();
            row.setNumber((number == null ? 0 : number) + 1);
            rowIndex = tableModel.updateRow((Serializable)((Object)row));
        } else {
            row = tableModel.createNewRow();
            row.setLengthStep(Float.valueOf(aroundLengthStep));
            row.setNumber(1);
            row.setValid(handler.isRowValid(row));
            ArrayList steps = Lists.newArrayList(rowsByStep.keySet());
            steps.add(Float.valueOf(aroundLengthStep));
            Collections.sort(steps);
            rowIndex = steps.indexOf(Float.valueOf(aroundLengthStep));
            tableModel.addNewRow(rowIndex, (Serializable)((Object)row));
        }
        int totalNumber = model.computeTotalNumber();
        model.setTotalNumber(totalNumber);
        this.ui.getTable().scrollRowToVisible(rowIndex);
        if (fromIchtyometer) {
            String unit = model.getLengthStepCaracteristicUnit();
            handler.showInformationMessage(I18n.t((String)"tutti.editSpeciesFrequencies.addMeasure", (Object[])new Object[]{step, Float.valueOf(aroundLengthStep), unit}));
        }
        JXTable logsTable = this.ui.getLogsTable();
        SpeciesFrequencyLogsTableModel logsTableModel = (SpeciesFrequencyLogsTableModel)((Object)logsTable.getModel());
        SpeciesFrequencyLogRowModel newRow = logsTableModel.createNewRow();
        newRow.setDate(new Date());
        newRow.setLengthStep(step);
        logsTableModel.addNewRow(0, (Serializable)((Object)newRow));
    }
}

