/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import fr.ifremer.tutti.persistence.entities.data.SampleCategory;
import fr.ifremer.tutti.persistence.entities.referential.CaracteristicQualitativeValue;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import org.jdesktop.swingx.JXTable;
import org.nuiton.i18n.I18n;

public class RenameBenthosBatchAction
extends LongActionSupport<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {
    protected Species selectedSpecies;

    public RenameBenthosBatchAction(BenthosBatchUIHandler handler) {
        super(handler, false);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        BenthosBatchRowModel row = (BenthosBatchRowModel)tableModel.getEntry(selectedRowIndex);
        List referents = this.getDataContext().getReferentSpecies();
        Map referentsById = Speciess.splitReferenceSpeciesByReferenceTaxonId((Iterable)referents);
        BenthosBatchUIModel model = (BenthosBatchUIModel)((BenthosBatchUIHandler)this.handler).getModel();
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Serializable categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsedForFirstCategory = model.getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        ArrayList speciesList = Lists.newArrayList((Iterable)this.getDataContext().getReferentBenthosWithSurveyCode(true));
        speciesList.removeAll(speciesUsedForFirstCategory);
        ArrayList<Species> allSpeciesList = new ArrayList<Species>(this.getDataContext().getSpecies());
        allSpeciesList.removeAll(speciesUsedForFirstCategory);
        allSpeciesList.removeAll(this.getDataContext().getReferentSpeciesWithSurveyCode(true));
        Multimap speciesByReferent = Speciess.splitByReferenceTaxonId(allSpeciesList);
        for (Species species : speciesUsedForFirstCategory) {
            Collection synonyms = speciesByReferent.get((Object)String.valueOf(species.getReferenceTaxonId()));
            allSpeciesList.removeAll(synonyms);
        }
        this.selectedSpecies = this.openAddSpeciesDialog(I18n.t((String)"tutti.selectSpecies.title", (Object[])new Object[0]), allSpeciesList, speciesList);
        if (this.selectedSpecies != null && !this.selectedSpecies.isReferenceTaxon()) {
            String decoratedSynonym = this.decorate(this.selectedSpecies, "fromProtocol");
            String taxonId = String.valueOf(this.selectedSpecies.getReferenceTaxonId());
            this.selectedSpecies = (Species)referentsById.get(taxonId);
            String decoratedReferent = this.decorate(this.selectedSpecies, "fromProtocol");
            this.sendMessage(I18n.t((String)"tutti.flash.info.species.replaced", (Object[])new Object[]{decoratedSynonym, decoratedReferent}));
        }
        return result &= this.selectedSpecies != null;
    }

    public void releaseAction() {
        this.selectedSpecies = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        BenthosBatchTableModel tableModel = ((BenthosBatchUIHandler)this.handler).getTableModel();
        JXTable table = ((BenthosBatchUIHandler)this.handler).getTable();
        int selectedRowIndex = SwingUtil.getSelectedModelRow((JTable)table);
        BenthosBatchRowModel row = (BenthosBatchRowModel)tableModel.getEntry(selectedRowIndex);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        persistenceService.changeBenthosBatchSpecies(row.getId(), this.selectedSpecies);
        SampleCategory<?> firstSampleCategory = row.getFirstSampleCategory();
        Serializable categoryValue = firstSampleCategory.getCategoryValue();
        Collection speciesUsed = ((BenthosBatchUIModel)this.getModel()).getSpeciesUsed().get((Object)((CaracteristicQualitativeValue)categoryValue));
        speciesUsed.remove(row.getSpecies());
        this.changeChildrenSpecies(row, this.selectedSpecies);
        speciesUsed.add(this.selectedSpecies);
    }

    protected void changeChildrenSpecies(BenthosBatchRowModel row, Species species) {
        row.setSpecies(species);
        List<BenthosBatchRowModel> children = row.getChildBatch();
        if (children != null) {
            for (BenthosBatchRowModel child : children) {
                this.changeChildrenSpecies(child, species);
            }
        }
    }
}

