/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.editor;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import jaxx.runtime.swing.editor.SimpleTimeEditor;
import jaxx.runtime.swing.editor.SimpleTimeEditorModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.beans.BeanUtil;

public class SimpleTimeEditorHandler {
    private static final Log log = LogFactory.getLog(SimpleTimeEditorHandler.class);
    private static final KeyAdapter MOVE_TO_MINUTES_KEY_LISTENER = new KeyAdapter(){

        @Override
        public void keyReleased(KeyEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String text = source.getText();
            if (text.length() >= 2 || !text.equals("0") && !text.equals("1") && !text.equals("2")) {
                source.transferFocus();
            }
        }
    };
    private final PropertyChangeListener propertyDateChanged;
    private final PropertyChangeListener propertyTimeChanged;
    private final SimpleTimeEditor editor;
    private final SimpleTimeEditorModel model;
    protected Method mutator;
    protected final Calendar calendarMinute;
    protected final Calendar calendarHour;

    public SimpleTimeEditorHandler(SimpleTimeEditor editor) {
        this.editor = editor;
        this.model = editor.getModel();
        this.calendarMinute = Calendar.getInstance();
        this.calendarHour = Calendar.getInstance();
        this.propertyDateChanged = new PropertyChangeListener(){
            protected final Calendar calendarDate = Calendar.getInstance();

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Date date = (Date)evt.getNewValue();
                if (date != null) {
                    this.calendarDate.setTime(date);
                    int hours = this.calendarDate.get(11);
                    int minutes = this.calendarDate.get(12);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("date changed : new value " + hours + ":" + minutes));
                    }
                    SimpleTimeEditorHandler.this.model.setTimeModel(hours * 60 + minutes);
                } else {
                    SimpleTimeEditorHandler.this.model.setTimeModel(null);
                }
            }
        };
        this.propertyTimeChanged = new PropertyChangeListener(){
            protected final Calendar calendarDate = Calendar.getInstance();

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Integer time = (Integer)evt.getNewValue();
                int hours = time / 60;
                int minutes = time % 60;
                this.calendarDate.set(11, hours);
                this.calendarDate.set(12, minutes);
                Date newValue = this.calendarDate.getTime();
                if (log.isDebugEnabled()) {
                    log.debug((Object)(SimpleTimeEditorHandler.this.model.getProperty() + " on " + SimpleTimeEditorHandler.this.model.getBean().getClass() + " :: " + newValue));
                }
                try {
                    SimpleTimeEditorHandler.this.getMutator().invoke((Object)SimpleTimeEditorHandler.this.model.getBean(), newValue);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void init() {
        if (this.model.getBean() == null) {
            throw new NullPointerException("can not have a null bean in ui " + (Object)((Object)this.editor));
        }
        this.editor.getMinute().setEditor(new JSpinner.DateEditor(this.editor.getMinute(), "mm"));
        JSpinner.DefaultEditor hourEditor = (JSpinner.DefaultEditor)this.editor.getHour().getEditor();
        hourEditor.getTextField().addKeyListener(MOVE_TO_MINUTES_KEY_LISTENER);
        this.model.addPropertyChangeListener("date", this.propertyDateChanged);
        this.model.addPropertyChangeListener("timeModel", this.propertyTimeChanged);
    }

    public SimpleTimeEditor getEditor() {
        return this.editor;
    }

    protected Date setMinuteModel(Date incomingDate) {
        if (incomingDate == null) {
            incomingDate = new Date();
            this.calendarMinute.setTime(incomingDate);
            this.calendarMinute.set(11, 0);
            this.calendarMinute.set(12, 0);
        } else {
            this.calendarMinute.setTime(incomingDate);
            this.calendarMinute.set(11, 0);
        }
        incomingDate = this.calendarMinute.getTime();
        return incomingDate;
    }

    public void updateTimeModelFromHour(Integer hour) {
        this.model.setTimeModel(hour * 60 + this.model.getMinute());
    }

    public void updateTimeModelFromMinute(Date minuteDate) {
        this.calendarMinute.setTime(minuteDate);
        int newHour = this.calendarMinute.get(11);
        int newMinute = this.calendarMinute.get(12);
        int oldHour = this.model.getHour();
        int oldMinute = this.model.getMinute();
        if (oldHour == newHour && oldMinute == newMinute) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Do not update time model , stay on same time = " + oldHour + ":" + oldMinute));
            }
            return;
        }
        int hour = oldHour;
        int minute = newMinute;
        if (log.isDebugEnabled()) {
            log.debug((Object)("hh:mm (old from dateModel)   = " + oldHour + ":" + oldMinute));
            log.debug((Object)("hh:mm (new from minuteModel) = " + newHour + ":" + newMinute));
        }
        SpinnerDateModel minuteModel = this.editor.getMinuteModel();
        if (newMinute == 0) {
            if (newHour == 1) {
                if (oldHour == 23) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Do not update time model , stay on hh:mm = " + oldHour + ":" + oldMinute));
                    }
                    minuteModel.setValue(minuteModel.getPreviousValue());
                    return;
                }
                hour = (oldHour + 1) % 24;
            }
        } else if (newMinute == 59 && newHour == 23) {
            if (oldHour == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Do not update time model , stay on hh:mm = " + oldHour + ":" + oldMinute));
                }
                minuteModel.setValue(minuteModel.getNextValue());
                return;
            }
            hour = (oldHour - 1) % 24;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Update time model to hh:mm = " + hour + ":" + minute));
        }
        this.model.setTimeModel(hour * 60 + minute);
    }

    protected void setDate(Date oldValue, Date newValue) {
        if (this.model.getBean() != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.model.getProperty() + " on " + this.model.getBean().getClass() + " :: " + oldValue + " to " + newValue));
            }
            try {
                this.getMutator().invoke((Object)this.model.getBean(), newValue);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    protected Method getMutator() {
        if (this.mutator == null) {
            Serializable bean = this.model.getBean();
            if (bean == null) {
                throw new NullPointerException("could not find bean in " + (Object)((Object)this.editor));
            }
            String property = this.model.getProperty();
            if (property == null) {
                throw new NullPointerException("could not find property in " + (Object)((Object)this.editor));
            }
            this.mutator = BeanUtil.getMutator((Object)bean, (String)property);
        }
        return this.mutator;
    }
}

