/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.simpleapi;

import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.FilterCondition;
import org.eclipse.birt.report.model.api.simpleapi.IFilterCondition;
import org.eclipse.birt.report.model.simpleapi.Structure;

public class FilterConditionImpl
extends Structure
implements IFilterCondition {
    private FilterCondition condition;

    public FilterConditionImpl() {
        super(null);
        this.condition = this.createFilterCondition();
    }

    public FilterConditionImpl(FilterCondition condition) {
        super(null);
        this.condition = condition == null ? this.createFilterCondition() : condition;
    }

    public FilterConditionImpl(FilterConditionHandle conditionHandle) {
        super(conditionHandle);
        if (conditionHandle == null) {
            this.condition = this.createFilterCondition();
        } else {
            this.structureHandle = conditionHandle;
            this.condition = (FilterCondition)conditionHandle.getStructure();
        }
    }

    private FilterCondition createFilterCondition() {
        FilterCondition f = new FilterCondition();
        return f;
    }

    @Override
    public String getOperator() {
        return this.condition.getOperator();
    }

    @Override
    public String getValue1() {
        return this.condition.getValue1();
    }

    @Override
    public String getValue2() {
        return this.condition.getValue2();
    }

    @Override
    public void setOperator(String operator) throws SemanticException {
        if (this.structureHandle != null) {
            ActivityStack cmdStack = this.structureHandle.getModule().getActivityStack();
            cmdStack.startNonUndoableTrans(null);
            try {
                ((FilterConditionHandle)this.structureHandle).setOperator(operator);
            }
            catch (SemanticException e) {
                cmdStack.rollback();
                throw e;
            }
            cmdStack.commit();
            return;
        }
        this.condition.setOperator(operator);
    }

    @Override
    public void setValue1(String value1) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("value1", value1);
            return;
        }
        this.condition.setValue1(value1);
    }

    @Override
    public void setValue2(String value2) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("value2", value2);
            return;
        }
        this.condition.setValue2(value2);
    }

    @Override
    public IStructure getStructure() {
        return this.condition;
    }

    @Override
    public String getExpr() {
        return this.condition.getExpr();
    }

    @Override
    public void setExpr(String expr) throws SemanticException {
        if (this.structureHandle != null) {
            this.setProperty("expr", expr);
            return;
        }
        this.condition.setExpr(expr);
    }
}

