/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.entities.referential;

import fr.ifremer.tutti.persistence.TuttiPersistence;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class TaxonCache {
    protected final boolean loadVernacularCode;
    protected final TuttiPersistence persistenceService;
    protected final Map<Integer, SpeciesProtocol> protocolMap;
    protected final Map<Integer, Species> speciesByReferenceTaxonId;

    TaxonCache(boolean loadVernacularCode, TuttiPersistence persistenceService, Map<Integer, SpeciesProtocol> protocolMap) {
        this.loadVernacularCode = loadVernacularCode;
        this.persistenceService = persistenceService;
        this.protocolMap = protocolMap;
        this.speciesByReferenceTaxonId = new TreeMap<Integer, Species>();
    }

    public String getLengthStepPmfmId(Species species) {
        SpeciesProtocol speciesProtocol = this.protocolMap.get(species.getReferenceTaxonId());
        String lengthStepPmfmId = speciesProtocol == null ? null : speciesProtocol.getLengthStepPmfmId();
        return lengthStepPmfmId;
    }

    public Float getLengthStep(Species species) {
        SpeciesProtocol speciesProtocol = this.protocolMap.get(species.getReferenceTaxonId());
        Float lengthStep = speciesProtocol == null ? null : speciesProtocol.getLengthStep();
        return lengthStep;
    }

    public void load(List<Species> speciesList) {
        for (Species species : speciesList) {
            this.load(species);
        }
    }

    public <A extends SpeciesAbleBatch> void loadInBatches(List<A> speciesAbleBatches) {
        for (SpeciesAbleBatch speciesAbleBatch : speciesAbleBatches) {
            this.load(speciesAbleBatch.getSpecies());
        }
    }

    public void load(Species species) {
        Integer referenceTaxonId = species.getReferenceTaxonId();
        Species speciesLoaded = this.speciesByReferenceTaxonId.get(referenceTaxonId);
        if (speciesLoaded == null) {
            if (this.loadVernacularCode) {
                Species speciesWithVerncularCode = this.persistenceService.getSpeciesByReferenceTaxonIdWithVernacularCode(referenceTaxonId);
                species.setVernacularCode(speciesWithVerncularCode.getVernacularCode());
            }
            if (this.protocolMap.containsKey(species.getReferenceTaxonId())) {
                SpeciesProtocol speciesProtocol = this.protocolMap.get(species.getReferenceTaxonId());
                String surveyCode = speciesProtocol.getSpeciesSurveyCode();
                species.setSurveyCode(surveyCode);
            }
            this.speciesByReferenceTaxonId.put(species.getReferenceTaxonId(), species);
        } else {
            species.setVernacularCode(speciesLoaded.getVernacularCode());
            species.setSurveyCode(speciesLoaded.getSurveyCode());
        }
    }
}

