/*
 * Decompiled with CFR 0.152.
 */
package freemarker.template;

import freemarker.template.utility.StringUtil;
import java.io.Serializable;
import java.util.Date;

public final class Version
implements Serializable {
    private final int major;
    private final int minor;
    private final int micro;
    private final String extraInfo;
    private final Boolean gaeCompliant;
    private final Date buildDate;
    private int intValue;
    private String stringValue;
    private Integer hashCode;

    public Version(String stringValue) {
        this(stringValue, null, null);
    }

    public Version(String stringValue, Boolean gaeCompliant, Date buildDate) {
        char firstChar;
        stringValue = stringValue.trim();
        int[] parts = new int[3];
        String extraInfoTmp = null;
        int partIdx = 0;
        boolean valid = false;
        for (int i = 0; i < stringValue.length(); ++i) {
            char c = stringValue.charAt(i);
            if (c >= '0' && c <= '9') {
                parts[partIdx] = parts[partIdx] * 10 + (c - 48);
                valid = true;
                continue;
            }
            if (c == '.') {
                if (partIdx == 2) {
                    extraInfoTmp = stringValue.substring(i);
                    break;
                }
                ++partIdx;
                continue;
            }
            extraInfoTmp = stringValue.substring(i);
            break;
        }
        if (!valid) {
            throw new IllegalArgumentException("A version number string " + StringUtil.jQuote(stringValue) + " must start with a number.");
        }
        if (extraInfoTmp != null && ((firstChar = extraInfoTmp.charAt(0)) == '.' || firstChar == '-' || firstChar == '_')) {
            extraInfoTmp = extraInfoTmp.substring(1);
        }
        this.extraInfo = extraInfoTmp;
        this.major = parts[0];
        this.minor = parts[1];
        this.micro = parts[2];
        this.calculateIntValue();
        this.stringValue = stringValue;
        this.gaeCompliant = gaeCompliant;
        this.buildDate = buildDate;
    }

    public Version(int major, int minor, int micro) {
        this(major, minor, micro, null, null, null);
    }

    public Version(int major, int minor, int micro, String extraInfo, Boolean gaeCompatible, Date buildDate) {
        this.major = major;
        this.minor = minor;
        this.micro = micro;
        this.extraInfo = extraInfo;
        this.gaeCompliant = gaeCompatible;
        this.buildDate = buildDate;
        this.calculateIntValue();
    }

    private void calculateIntValue() {
        this.intValue = Version.intValueFor(this.major, this.minor, this.micro);
    }

    public static int intValueFor(int major, int minor, int micro) {
        return major * 1000000 + minor * 1000 + micro;
    }

    public synchronized String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.major + "." + this.minor + "." + this.micro;
            if (this.extraInfo != null) {
                this.stringValue = this.stringValue + "-" + this.extraInfo;
            }
        }
        return this.stringValue;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getMicro() {
        return this.micro;
    }

    public String getExtraInfo() {
        return this.extraInfo;
    }

    public Boolean isGAECompliant() {
        return this.gaeCompliant;
    }

    public Date getBuildDate() {
        return this.buildDate;
    }

    public int intValue() {
        return this.intValue;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.buildDate == null ? 0 : this.buildDate.hashCode());
            result = 31 * result + (this.extraInfo == null ? 0 : this.extraInfo.hashCode());
            result = 31 * result + (this.gaeCompliant == null ? 0 : this.gaeCompliant.hashCode());
            result = 31 * result + (this.hashCode == null ? 0 : this.hashCode.hashCode());
            result = 31 * result + this.intValue;
            result = 31 * result + (this.stringValue == null ? 0 : this.stringValue.hashCode());
            this.hashCode = new Integer(result);
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.intValue != other.intValue) {
            return false;
        }
        if (other.hashCode() != this.hashCode()) {
            return false;
        }
        if (this.buildDate == null ? other.buildDate != null : !this.buildDate.equals(other.buildDate)) {
            return false;
        }
        if (this.extraInfo == null ? other.extraInfo != null : !this.extraInfo.equals(other.extraInfo)) {
            return false;
        }
        return !(this.gaeCompliant == null ? other.gaeCompliant != null : !this.gaeCompliant.equals(other.gaeCompliant));
    }
}

