/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.psionimport;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.psionimport.PsionImportBatchModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class PsionImportModel {
    private static final Log log = LogFactory.getLog(PsionImportModel.class);
    protected final LinkedHashSet<Species> speciesSet = new LinkedHashSet();
    protected final Multimap<Species, PsionImportBatchModel> sortedBatchsBySpecies = ArrayListMultimap.create();
    protected final Multimap<Species, PsionImportBatchModel> unsortedBatchsBySpecies = ArrayListMultimap.create();
    protected final List<String> errors = Lists.newArrayList();

    public boolean withBatchs() {
        return !this.speciesSet.isEmpty();
    }

    public Set<Species> getSpecies() {
        ImmutableSet result = ImmutableSet.copyOf(this.speciesSet);
        return result;
    }

    public List<PsionImportBatchModel> getUnsortedBatches(Species species) {
        Collection batches = this.unsortedBatchsBySpecies.get((Object)species);
        ImmutableList result = null;
        if (batches != null) {
            result = ImmutableList.copyOf((Collection)batches);
        }
        return result;
    }

    public List<PsionImportBatchModel> getSortedBatches(Species species) {
        Collection batches = this.sortedBatchsBySpecies.get((Object)species);
        ImmutableList result = null;
        if (batches != null) {
            result = ImmutableList.copyOf((Collection)batches);
        }
        return result;
    }

    public Set<Integer> getSampleCategoryIdUsed() {
        PsionImportBatchModel.SampleCategory next;
        Iterator<PsionImportBatchModel.SampleCategory> categoryIterator;
        HashSet result = Sets.newHashSet();
        for (PsionImportBatchModel batch : this.sortedBatchsBySpecies.values()) {
            categoryIterator = batch.getCategoryIterator();
            while (categoryIterator.hasNext()) {
                next = categoryIterator.next();
                result.add(next.getCategoryId());
            }
        }
        for (PsionImportBatchModel batch : this.unsortedBatchsBySpecies.values()) {
            categoryIterator = batch.getCategoryIterator();
            while (categoryIterator.hasNext()) {
                next = categoryIterator.next();
                result.add(next.getCategoryId());
            }
        }
        return result;
    }

    public boolean withErrors() {
        return !this.errors.isEmpty();
    }

    public List<String> getErrors() {
        return this.errors;
    }

    void addBatch(PsionImportBatchModel batchModel) {
        Multimap<Species, PsionImportBatchModel> store;
        Species species = batchModel.getSpecies();
        this.speciesSet.add(species);
        String categoryCode = batchModel.getCategoryCode();
        Float weight = batchModel.getWeight();
        Float sampleWeight = batchModel.getSampleWeight();
        if (TuttiEntities.isGreaterWeight((float)weight.floatValue(), (float)0.0f) && TuttiEntities.isEqualWeight((float)weight.floatValue(), (float)sampleWeight.floatValue())) {
            store = this.unsortedBatchsBySpecies;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found a unsorted batch [%s] %s - %s", species.getSurveyCode(), weight, sampleWeight));
            }
        } else {
            store = this.sortedBatchsBySpecies;
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Found a sorted batch [%s] %s - %s", species.getSurveyCode(), weight, sampleWeight));
            }
        }
        Collection psionImportBatchModels = store.get((Object)species);
        PsionImportBatchModel mergeBatch = null;
        if (CollectionUtils.isNotEmpty((Collection)psionImportBatchModels)) {
            for (PsionImportBatchModel importBatchModel : psionImportBatchModels) {
                if (!categoryCode.equals(importBatchModel.getCategoryCode())) continue;
                mergeBatch = importBatchModel;
                break;
            }
        }
        if (mergeBatch == null) {
            store.put((Object)species, (Object)batchModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Added " + batchModel));
            }
        } else {
            mergeBatch.merge(batchModel);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Merged " + batchModel + " to " + mergeBatch));
            }
        }
    }

    void addError(String error) {
        this.errors.add(error);
    }

    void cleanSortedBatches() {
        for (Species species : this.sortedBatchsBySpecies.keySet()) {
            for (PsionImportBatchModel batchModel : this.sortedBatchsBySpecies.get((Object)species)) {
                Float weight = batchModel.getWeight();
                Float sampleWeight = batchModel.getSampleWeight();
                if (!TuttiEntities.isEqualWeight((float)weight.floatValue(), (float)0.0f) || !TuttiEntities.isGreaterWeight((float)sampleWeight.floatValue(), (float)0.0f)) continue;
                batchModel.setWeight(sampleWeight);
                batchModel.setSampleWeight(null);
            }
        }
    }

    void cleanUnsortedBatches() {
        for (Species species : this.unsortedBatchsBySpecies.keySet()) {
            for (PsionImportBatchModel batchModel : this.unsortedBatchsBySpecies.get((Object)species)) {
                batchModel.setSampleWeight(null);
            }
        }
    }

    void checkSortedBatches() throws IOException {
        for (Species species : this.sortedBatchsBySpecies.keySet()) {
            ArrayList<PsionImportBatchModel> speciesBatchesWithDoubleWeight = new ArrayList<PsionImportBatchModel>();
            ArrayList<PsionImportBatchModel> speciesBatchesWithDoubleWeightAndCat = new ArrayList<PsionImportBatchModel>();
            for (PsionImportBatchModel batchModel : this.sortedBatchsBySpecies.get((Object)species)) {
                Float weight = batchModel.getWeight();
                Float sampleWeight = batchModel.getSampleWeight();
                if (TuttiEntities.isEqualWeight((float)weight.floatValue(), (float)0.0f) && TuttiEntities.isGreaterWeight((float)sampleWeight.floatValue(), (float)0.0f) || !TuttiEntities.isGreaterWeight((float)weight.floatValue(), (float)0.0f) || !TuttiEntities.isGreaterWeight((float)weight.floatValue(), (float)sampleWeight.floatValue())) continue;
                speciesBatchesWithDoubleWeight.add(batchModel);
                if (!batchModel.withCategories()) continue;
                speciesBatchesWithDoubleWeightAndCat.add(batchModel);
            }
            if (speciesBatchesWithDoubleWeight.isEmpty()) continue;
            if (speciesBatchesWithDoubleWeightAndCat.size() == speciesBatchesWithDoubleWeight.size()) {
                for (PsionImportBatchModel batchModel : speciesBatchesWithDoubleWeight) {
                    batchModel.setApplyBothWeightOnCategorizedBatch(true);
                }
                continue;
            }
            if (speciesBatchesWithDoubleWeight.size() == 1 && speciesBatchesWithDoubleWeightAndCat.isEmpty()) continue;
            throw new IOException(I18n.t((String)"tutti.service.psionimport.error.inconsistentVracCategory.message", (Object[])new Object[]{species.getSurveyCode()}));
        }
    }
}

